﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

namespace NintendoWare.G3d.Edit
{
    public abstract class EditIndicesModelCommand : EditModelCommand
    {
        private readonly int[] indices;
        protected EditIndicesModelCommand(TargetEndianKind targetEndian, IEditModelTarget target, int[] indices)
            : base(targetEndian, target)
        {
            Debug.Assert(indices != null, "Invalid argument.");
            this.indices = new int[indices.Length];
            indices.CopyTo(this.indices, 0);
        }

        protected override bool CanProcessImpl()
        {
            if (!base.CanProcessImpl())
            {
                return false;
            }

            foreach (var index in this.indices)
            {
                if (index < 0)
                {
                    return false;
                }
            }
            return true;
        }

        protected int[] Indices
        {
            get
            {
                return this.indices;
            }
        }
    }

    public abstract class EditIndicesModelCommand<T> : EditIndicesModelCommand// where T : struct
    {
        private readonly T value;
        protected EditIndicesModelCommand(TargetEndianKind targetEndian, IEditModelTarget target, int[] indices, T value)
            : base(targetEndian, target, indices)
        {
            this.value = value;
        }

        protected T Value
        {
            get
            {
                return this.value;
            }
        }
    }
}
