﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;

namespace Nintendo.InGameEditing.WPF
{
    /// <summary>
    /// テキストボックスにファイルドロップの機能を付加する添付プロパティ
    /// </summary>
    public class TextBoxFileDropProperty
    {
        public static bool GetIsEnabled(DependencyObject obj)
        {
            return (bool)obj.GetValue(IsEnabledProperty);
        }

        public static void SetIsEnabled(DependencyObject obj, bool value)
        {
            obj.SetValue(IsEnabledProperty, value);
        }

        public static readonly DependencyProperty IsEnabledProperty =
            DependencyProperty.RegisterAttached("IsEnabled", typeof(bool), typeof(TextBoxFileDropProperty),
            new PropertyMetadata(false, IsEnabledChanged));

        private static void IsEnabledChanged(DependencyObject obj, DependencyPropertyChangedEventArgs e)
        {
            TextBox textBox = obj as TextBox;
            if ((bool)e.NewValue)
            {
                textBox.PreviewDragOver += TextBoxOnPreviewDragOver;
                textBox.Drop += TextBoxOnDrop;
            }
            else
            {
                textBox.PreviewDragOver -= TextBoxOnPreviewDragOver;
                textBox.Drop -= TextBoxOnDrop;
            }
        }

        private static void TextBoxOnDrop(object sender, DragEventArgs dragEventArgs)
        {
            var textBox = sender as TextBox;
            if (textBox == null)
            {
                return;
            }

            var fileInfos = dragEventArgs.Data.GetData(DataFormats.FileDrop) as string[];

            var text = fileInfos?.FirstOrDefault();
            if (text == null)
            {
                return;
            }

            textBox.Text = text;
        }

        private static void TextBoxOnPreviewDragOver(object sender, DragEventArgs dragEventArgs)
        {
            if (dragEventArgs.Data.GetData(DataFormats.FileDrop) != null)
            {
                dragEventArgs.Effects = DragDropEffects.Copy;
            }
            else
            {
                dragEventArgs.Effects = DragDropEffects.None;
            }
            dragEventArgs.Handled = true;
        }
    }
}
