﻿namespace Nintendo.InGameEditing
{
    public struct Version
    {
        public Version(ushort major, byte minor, byte micro)
        {
            Major = major;
            Minor = minor;
            Micro = micro;
        }

        public ushort Major { get; }
        public byte Minor { get; }
        public byte Micro { get; }

        public static explicit operator uint(Version version)
        {
            return (uint)(version.Major << 16 & version.Minor << 8 & version.Micro);
        }

        public static explicit operator Version(uint value)
        {
            var major = (ushort)(value >> 16);
            var minor = (byte)((value >> 8) & 0xFF);
            var micro = (byte)(value & 0xFF);
            return new Version(major, minor, micro);
        }

        public bool IsCompatible(Version target)
        {
            return Major == target.Major && Minor >= target.Minor;
        }

        public override string ToString() => $"{Major}.{Minor}.{Micro}";
    }
}
