﻿using System;

namespace Nintendo.InGameEditing
{
    /// <summary>
    /// ユーザーデータの受信時に発効されるイベントの引数です。
    /// </summary>
    public class UserDataReceivedEventArgs : EventArgs
    {
        private static readonly byte[] EmptyBytes = new byte[0];

        internal UserDataReceivedEventArgs(byte[] data)
        {
            UserData = data ?? EmptyBytes;
        }

        /// <summary>
        /// 受信したユーザーデータを取得します。
        /// </summary>
        public byte[] UserData { get; }
    }
}
