﻿using System.IO;
using Nintendo.InGameEditing.Communication;
using Nintendo.InGameEditing.Utilities;

namespace Nintendo.InGameEditing.Messages
{
    internal class NodeMessage : SystemMessage
    {
        public static MessageType MessageType => MessageType.Node;

        public NodeMessage(uint id, uint parentId, NodeType nodeType, string typeName, byte[] metadata)
        {
            Id = id;
            ParentId = parentId;
            NodeType = nodeType;
            TypeName = typeName;
            Metadata = metadata ?? Const.EmptyBytes;
        }

        public uint Id { get; }

        public uint ParentId { get; }

        public NodeType NodeType { get; }

        public string TypeName { get; }

        public byte[] Metadata { get; }

        internal static NodeMessage Parse(Packet packet)
        {
            // Read
            using (var stream = new MemoryStream(packet.Payload, 0, packet.Payload.Length, false, true))
            using (var reader = new BinaryReader(stream))
            {
                var messageType = (MessageType)reader.ReadInt32();
                if (messageType != MessageType) { throw new InvalidDataException(); }

                var id = reader.ReadUInt32();
                var parentId = reader.ReadUInt32();
                var node = (NodeType)reader.ReadInt32();
                var typeName = stream.ReadNullTerminatedUTF8String();
                var metaData = reader.ReadBytes((int)(stream.Length - stream.Position));

                return new NodeMessage(id, parentId, node, typeName, metaData);
            }
        }
    }
}
