﻿using System;
using System.Text;

namespace Nintendo.InGameEditing
{
    internal static class Const
    {
        private const string SignatureString = "IGE_";
        public static readonly int Signature = BitConverter.ToInt32(Encoding.ASCII.GetBytes(SignatureString), 0);
        public static readonly Version CurrentVersion = new Version(0, 0, 0);

        internal static readonly byte[] EmptyBytes = new byte[0];
    }

    /// <summary>
    /// ノードの種別を示します。
    /// </summary>
    public enum NodeType : int
    {
        /// <summary>
        /// 通常のノードです。
        /// </summary>
        Normal = 0x00,

        /// <summary>
        /// コマンドの送受信が可能なノードです。
        /// </summary>
        Command = 0x01,

        /// <summary>
        /// 値の送受信を行うノードです。
        /// </summary>
        Value = 0x02,
    };
}
