﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Foundation.Contracts;
using System.Runtime.InteropServices;

namespace Nintendo.Atk.Binary
{
    /// <summary>
    /// 波形フォーマット情報を格納します。
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 8)]
    internal struct AtkNativeWaveFormat
    {
        /// <summary>
        /// エンコーディングです。
        /// </summary>
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 16)]
        public string Encoding;

        /// <summary>
        /// チャンネル数です。
        /// </summary>
        [MarshalAs(UnmanagedType.I4)]
        public int ChannelCount;

        /// <summary>
        /// サンプルレートです。
        /// </summary>
        [MarshalAs(UnmanagedType.I4)]
        public int Samplerate;
    }
}
