﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Runtime.InteropServices;

namespace Nintendo.Atk.Binary
{
    /// <summary>
    /// 波形バイナリ情報を格納します。
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 8)]
    internal struct AtkNativeWaveBinaryInfo
    {
        /// <summary>
        /// 波形フォーマットです。
        /// </summary>
        public AtkNativeWaveFormat Format;

        /// <summary>
        /// サンプル数です。
        /// </summary>
        [MarshalAs(UnmanagedType.I8)]
        public long SampleCount;

        /// <summary>
        /// ループの有無です。
        /// </summary>
        [MarshalAs(UnmanagedType.Bool)]
        public bool HasLoop;

        /// <summary>
        /// ループ開始位置です。
        /// </summary>
        [MarshalAs(UnmanagedType.I8)]
        public long LoopStartFrame;

        /// <summary>
        /// ループ終了位置です。
        /// </summary>
        [MarshalAs(UnmanagedType.I8)]
        public long LoopEndFrame;

        /// <summary>
        /// ループ補正前のループ開始位置です。
        /// </summary>
        [MarshalAs(UnmanagedType.I8)]
        public long OriginalLoopStartFrame;

        /// <summary>
        /// ループ補正前のループ終了位置です。
        /// </summary>
        [MarshalAs(UnmanagedType.I8)]
        public long OriginalLoopEndFrame;
    }
}
