﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/atkTool/atkTool_WaveBinaryInfo.h>
#include "atktool_Result.h"

#ifdef _WINDLL
#define NN_ATKTOOL_DLLAPI extern "C" __declspec(dllexport)
#else
#define NN_ATKTOOL_DLLAPI extern "C" __declspec(dllimport)
#endif

NN_ATKTOOL_DLLAPI nnatktoolResult OpenBfwav(void* bfwavData, void** outHandle);
NN_ATKTOOL_DLLAPI nnatktoolResult CloseBfwav(void* handle);
NN_ATKTOOL_DLLAPI nnatktoolResult GetBfwavWaveBinaryInfo(void* handle, nnatktoolWaveBinaryInfo* info);
NN_ATKTOOL_DLLAPI uint64_t        GetRequiredBufferSizeForDecodeBfwav(void* handle);
NN_ATKTOOL_DLLAPI nnatktoolResult DecodeBfwav(void* handle, int channel, void* outputBuffer, uint64_t outputBufferSize);

NN_ATKTOOL_DLLAPI nnatktoolResult OpenBfstm(void* bfstmData, void** outHandle);
NN_ATKTOOL_DLLAPI nnatktoolResult CloseBfstm(void* handle);
NN_ATKTOOL_DLLAPI nnatktoolResult GetBfstmWaveBinaryInfo(void* handle, nnatktoolWaveBinaryInfo* info);
NN_ATKTOOL_DLLAPI uint64_t        GetRequiredBufferSizeForDecodeBfstm(void* handle);
NN_ATKTOOL_DLLAPI nnatktoolResult DecodeBfstm(void* handle, int channel, void* outputBuffer, uint64_t outputBufferSize);
