﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"
#include "atkTool_WaveDecoder.h"
#include <nn/nn_Assert.h>
#include <nn/atk/atk_Global.h>
#include <nn/util/util_BytePtr.h>

namespace nn { namespace atkTool { namespace detail {

void DecodePcm16LE(const void* input, void* output, int32_t sampleCount, size_t outputSize)
{
    NN_ASSERT_NOT_NULL(input);
    NN_ASSERT_NOT_NULL(output);
    NN_ASSERT_GREATER_EQUAL(outputSize, sampleCount * sizeof(int16_t));

    const int16_t* in = reinterpret_cast<const int16_t*>(input);
    int16_t* out = reinterpret_cast<int16_t*>(output);

    // 何もせず、そのまま代入する
    for (int i = 0; i < sampleCount; i++)
    {
        out[i] = in[i];
    }
}

void DecodeAdpcm(
    int16_t* output,
    nn::codec::AdpcmContext& adpcmContext,
    const nn::codec::AdpcmParameter& adpcmParameter,
    const void* input,
    size_t sampleCount)
{
    size_t frame = 0;
    size_t currentSample = 0;

    // output に直接デコード結果を出力する
    // 最終フレームで 14 サンプルに満たない場合は、テンポラリ領域にデコードしてコピーする
    while(currentSample + nn::codec::AdpcmFrameSampleCount <= sampleCount)
    {
        nn::codec::DecodeAdpcm(
            util::BytePtr(output, currentSample * sizeof(int16_t)).Get<int16_t>(),
            &adpcmContext,
            &adpcmParameter,
            util::ConstBytePtr(input, frame * nn::codec::AdpcmFrameSize).Get(),
            nn::codec::AdpcmFrameSize,
            nn::codec::AdpcmFrameSampleCount);

        frame++;
        currentSample += nn::codec::AdpcmFrameSampleCount;
    }

    int restSampleCount = static_cast<int>(sampleCount - currentSample);

    if(restSampleCount > 0)
    {
        int16_t lastFrameOutput[nn::codec::AdpcmFrameSampleCount];

        nn::codec::DecodeAdpcm(
            lastFrameOutput,
            &adpcmContext,
            &adpcmParameter,
            util::ConstBytePtr(input, frame * nn::codec::AdpcmFrameSize).Get(),
            nn::codec::AdpcmFrameSize,
            restSampleCount);

        for(int i = 0; i < restSampleCount; i++)
        {
            output[currentSample + i] = lastFrameOutput[i];
        }
    }
}

} } }
