﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/atk.h>


class SoundArchiveContext;

//! @brief  SoundHandle をラップしたクラスです
class WrappedSoundHandle
{
public:
    //! @brief  コンストラクタです
    explicit WrappedSoundHandle() NN_NOEXCEPT;
    //! @brief  初期化します
    void Initialize(SoundArchiveContext* pSoundArchiveContext, nn::atk::SoundHandle* pSoundHandle, int handleIndex) NN_NOEXCEPT;
    //! @brief  終了処理をします
    void Finalize() NN_NOEXCEPT;
    //! @brief  更新します
    void Update() NN_NOEXCEPT;

    //! @brief  再生します
    void Start() NN_NOEXCEPT;
    //! @brief  停止します
    void Stop() NN_NOEXCEPT;
    //! @brief  一時停止または再開します
    void Pause() NN_NOEXCEPT;

    //! @brief  再生中であるか
    bool IsPlaying() const NN_NOEXCEPT;
    //! @brief  一時停止しているか
    bool IsPaused() const NN_NOEXCEPT;
    //! @brief  停止しているか
    bool IsStoppped() const NN_NOEXCEPT;

    //! @brief  サウンドのラベルを取得します
    //          ラベルの取得に失敗したときは nullptr を返します
    const char* GetSoundLabel() const NN_NOEXCEPT;
    //! @brief  パラメータを適用する必要があるかどうかを設定します
    void SetParameterIsDirty(bool isDirty) NN_NOEXCEPT;

    //--  パラメータの Set, Get 関数  --//
    int GetHandleIndex() const NN_NOEXCEPT;
    void SetSoundIndex(uint32_t index) NN_NOEXCEPT;
    uint32_t GetSoundIndex() const NN_NOEXCEPT;
    void SetVolume(float volume) NN_NOEXCEPT;
    float GetVolume() const NN_NOEXCEPT;
    void SetPitch(float pitch) NN_NOEXCEPT;
    float GetPitch() const NN_NOEXCEPT;
    void SetStartOffset(int startOffset) NN_NOEXCEPT;
    int GetStartOffset() const NN_NOEXCEPT;
    void SetPan(float pan) NN_NOEXCEPT;
    float GetPan() const NN_NOEXCEPT;
    void SetSPan(float pan) NN_NOEXCEPT;
    float GetSPan() const NN_NOEXCEPT;
    void SetMainSend(float send) NN_NOEXCEPT;
    float GetMainSend() const NN_NOEXCEPT;
    void SetEffectSendA(float send) NN_NOEXCEPT;
    float GetEffectSendA() const NN_NOEXCEPT;
    void SetEffectSendB(float send) NN_NOEXCEPT;
    float GetEffectSendB() const NN_NOEXCEPT;
    void SetEffectSendC(float send) NN_NOEXCEPT;
    float GetEffectSendC() const NN_NOEXCEPT;
    void SetLpfFrequency(float value) NN_NOEXCEPT;
    float GetLpfFrequency() const NN_NOEXCEPT;
    void SetBqfType(int type) NN_NOEXCEPT;
    int GetBqfType() const NN_NOEXCEPT;
    void SetBqfValue(float value) NN_NOEXCEPT;
    float GetBqfValue() const NN_NOEXCEPT;
    void SetMainOutVolume(float volume) NN_NOEXCEPT;
    float GetMainOutVolume() const NN_NOEXCEPT;
    void SetPanMain(float pan) NN_NOEXCEPT;
    float GetPanMain() const NN_NOEXCEPT;
    void SetSPanMain(float pan) NN_NOEXCEPT;
    float GetSPanMain() const NN_NOEXCEPT;
    void SetMainSendMain(float send) NN_NOEXCEPT;
    float GetMainSendMain() const NN_NOEXCEPT;
    void SetEffectSendAMain(float send) NN_NOEXCEPT;
    float GetEffectSendAMain() const NN_NOEXCEPT;
    void SetEffectSendBMain(float send) NN_NOEXCEPT;
    float GetEffectSendBMain() const NN_NOEXCEPT;
    void SetEffectSendCMain(float send) NN_NOEXCEPT;
    float GetEffectSendCMain() const NN_NOEXCEPT;
    void SetOutputLine(uint32_t lineFlag) NN_NOEXCEPT;
    uint32_t GetOutputLine() const NN_NOEXCEPT;

private:
    //! @brief  パラメータを適用します
    void ApplyParameters() NN_NOEXCEPT;

private:
    SoundArchiveContext* m_pSoundArchiveContext;
    nn::atk::SoundHandle* m_pSoundHandle;
    bool m_IsDirtyParameter;
    int m_HandleIndex;

    uint32_t m_SoundIndex;
    float m_Volume;
    float m_Pitch;
    int   m_StartOffset;
    float m_Pan;
    float m_SPan;
    float m_MainSend;
    float m_EffectSendA;
    float m_EffectSendB;
    float m_EffectSendC;
    float m_LpfFrequency;
    int   m_BqfType;
    float m_BqfValue;
    float m_MainOutVolume;
    float m_PanMain;
    float m_SPanMain;
    float m_MainSendMain;
    float m_EffectSendAMain;
    float m_EffectSendBMain;
    float m_EffectSendCMain;
    uint32_t m_OutputLine;
};
