﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/util/util_MathTypes.h>
#include <nn/audio.h>


//!@brief  パラメータを増減させた値を返します
template <typename T> extern T ChangeParameterValue(T value, T increment, T boost, bool isBoost, bool isIncrement, const char* logTag, const char* logText);


//!@brief  ループする選択を行う
extern int GetNextValueOnLoopSelection(int next, int loopCount) NN_NOEXCEPT;

//!@brief  MemoryPool をアタッチします
extern void AttachMemoryPool(nn::audio::MemoryPoolType* pMemoryPool, void* buffer, size_t bufferSize) NN_NOEXCEPT;
//!@brief  MemoryPool をデタッチします
extern void DetachMemoryPool(nn::audio::MemoryPoolType* pMemoryPool) NN_NOEXCEPT;

extern const nn::util::Float2 GetFloat2(float x, float y) NN_NOEXCEPT;
extern const nn::util::Uint8x4 GetUint8x4(uint8_t x, uint8_t y, uint8_t z, uint8_t w) NN_NOEXCEPT;
extern const nn::util::Unorm8x4 GetUnorm8x4(uint8_t x, uint8_t y, uint8_t z, uint8_t w) NN_NOEXCEPT;
