﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "InformationPanel.h"

namespace
{
    //  Edit ランプのテキスト
    const char* EditLampText = "Edit";
    //  Edit ランプの枠の大きさ
    const float EditLampEdgeSize = 4.0f;
    //  Edit ランプの接続時, 切断時の色
    const nn::util::Uint8x4 EditLampConnectedColor    = GetUint8x4( 192, 16, 16, 255 );
    const nn::util::Uint8x4 EditLampDisconnectedColor = GetUint8x4(  16, 16, 16, 255 );
}

//  初期化します
void InformationPanel::Initialize(float positionX, float positionY, float sizeX, float sizeY) NN_NOEXCEPT
{
    m_IsConnected = false;

    m_Edit.SetText( EditLampText );
    m_Edit.SetPosition( positionX, positionY );
    m_Edit.SetEdgeSize( EditLampEdgeSize );
    m_Edit.SetDrawAlign( gfxutil::Label::DrawAlign_Left );
    m_Edit.SetBackColor( EditLampDisconnectedColor );
    m_Edit.SetEdgeColor( EditLampDisconnectedColor );

    NN_UNUSED( sizeX );
    NN_UNUSED( sizeY );

    //  RELOAD_SOUND_ARCHIVE_TEMP: サウンドアーカイブの再読み込みのための暫定処理
    m_ReloadSoundArchive.SetText( "Reloaded" );
    m_ReloadSoundArchive.SetPosition( positionX - 64.0f, positionY );
    m_ReloadSoundArchive.SetEdgeSize( 4.0f );
    m_ReloadSoundArchive.SetDrawAlign( gfxutil::Label::DrawAlign_Left );
    m_DisplayReloadLabelCount = 0;
}
//  更新します
void InformationPanel::Update(const SoundArchiveContext& soundArchiveContext) NN_NOEXCEPT
{
    if( m_IsConnected != soundArchiveContext.IsConnected() )
    {
        m_IsConnected = soundArchiveContext.IsConnected();

        if( m_IsConnected )
        {
            m_Edit.SetBackColor( EditLampConnectedColor );
            m_Edit.SetEdgeColor( EditLampConnectedColor );
        }
        else
        {
            m_Edit.SetBackColor( EditLampDisconnectedColor );
            m_Edit.SetEdgeColor( EditLampDisconnectedColor );
        }
    }

    //  RELOAD_SOUND_ARCHIVE_TEMP: サウンドアーカイブの再読み込みのための暫定処理
    if( m_DisplayReloadLabelCount > 0 )
    {
        m_DisplayReloadLabelCount--;
    }
}
//  描画します
void InformationPanel::Draw(gfxutil::GfxContext& gfxContext) NN_NOEXCEPT
{
    //  Panel と名づけていますが、今はパネルを表示していません
    m_Edit.Draw( gfxContext );

    //  RELOAD_SOUND_ARCHIVE_TEMP: サウンドアーカイブの再読み込みのための暫定処理
    if( IsDrawReloadLabel() )
    {
        const uint8_t alpha = static_cast<uint8_t>( std::min( 255, m_DisplayReloadLabelCount * 3 ) );
        nn::util::Uint8x4 color = GetUint8x4(   0,  64,   0, alpha );
        nn::util::Unorm8x4 text = GetUnorm8x4( 255, 255, 255, alpha );
        m_ReloadSoundArchive.SetBackColor( color );
        m_ReloadSoundArchive.SetEdgeColor( color );
        m_ReloadSoundArchive.SetColor( text );

        m_ReloadSoundArchive.Draw( gfxContext );
    }
}

//  SoundMaker と接続されているかを返します
bool InformationPanel::IsConnected() const NN_NOEXCEPT
{
    return m_IsConnected;
}
//  RELOAD_SOUND_ARCHIVE_TEMP: サウンドアーカイブの再読み込みのための暫定処理
//  Reload ラベルを表示しているかを返します
bool InformationPanel::IsDrawReloadLabel() const NN_NOEXCEPT
{
    return m_DisplayReloadLabelCount > 0;
}

//  RELOAD_SOUND_ARCHIVE_TEMP: サウンドアーカイブの再読み込みのための暫定処理
//  サウンドアーカイブが再読み込みされたときに呼ばれます
void InformationPanel::OnReloadSoundArchive() NN_NOEXCEPT
{
    m_DisplayReloadLabelCount = 150;
}
