﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vfx/viewer/vfx_Guid.h>
#include <nn/vfx/vfx_TargetDef.h>

namespace nn {
namespace vfx {
namespace viewer {
namespace detail {

//---------------------------------------------------------------------------------------------
//  コンストラクタです.
//---------------------------------------------------------------------------------------------
Guid::Guid() NN_NOEXCEPT
{
    Clear();
}

//---------------------------------------------------------------------------------------------
//  引数付きコンストラクタです.
//---------------------------------------------------------------------------------------------
Guid::Guid( const char data[ 16 ] ) NN_NOEXCEPT
{
    for( int i = 0; i < 16; ++i )
    {
        m_Data[ i ] = data[ i ];
    }
}

//---------------------------------------------------------------------------------------------
//  値をクリアします。
//---------------------------------------------------------------------------------------------
void Guid::Clear() NN_NOEXCEPT
{
    for( int i = 0; i < 16; ++i )
    {
        m_Data[ i ] = 0;
    }
}

//---------------------------------------------------------------------------------------------
//  代入演算子です.
//---------------------------------------------------------------------------------------------
Guid& Guid::operator= ( const Guid& value ) NN_NOEXCEPT
{
    for( int i = 0; i < 16; ++i )
    {
        m_Data[ i ] = value.m_Data[ i ];
    }

    return ( *this );
}

//---------------------------------------------------------------------------------------------
//  等価比較演算子です.
//---------------------------------------------------------------------------------------------
bool Guid::operator== ( const Guid& value ) const NN_NOEXCEPT
{
    for( int i = 0; i < 16; ++i )
    {
        if( m_Data[ i ] != value.m_Data[ i ] )
        {
            return false;
        }
    }

    return true;
}

//---------------------------------------------------------------------------------------------
//  非等価比較演算子です.
//---------------------------------------------------------------------------------------------
bool Guid::operator!= ( const Guid& value ) const NN_NOEXCEPT
{
    for( int i = 0; i < 16; ++i )
    {
        if( m_Data[ i ] != value.m_Data[ i ] )
        {
            return true;
        }
    }

    return false;
}

//---------------------------------------------------------------------------------------------
//  文字列に変換します.
//---------------------------------------------------------------------------------------------
char* Guid::GetString( char* pOutString, size_t size ) NN_NOEXCEPT
{
    NN_SDK_ASSERT( size >= GuidSettings_StringBufferSize );
    memset( pOutString, 0, size );

#if defined( NN_BUILD_CONFIG_OS_WIN )
    sprintf_s( pOutString, size, "%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x",
        m_Data[  0 ], m_Data[  1 ], m_Data[  2 ], m_Data[  3 ],
        m_Data[  4 ], m_Data[  5 ],
        m_Data[  6 ], m_Data[  7 ],
        m_Data[  8 ], m_Data[  9 ],
        m_Data[ 10 ], m_Data[ 11 ], m_Data[ 12 ], m_Data[ 13 ], m_Data[ 14 ], m_Data[ 15 ] );
#else
    sprintf( pOutString, "%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x",
        m_Data[  0 ], m_Data[  1 ], m_Data[ 2 ], m_Data[ 3 ],
        m_Data[  4 ], m_Data[  5 ],
        m_Data[  6 ], m_Data[  7 ],
        m_Data[  8 ], m_Data[  9 ],
        m_Data[ 10 ], m_Data[ 11 ], m_Data[ 12 ], m_Data[ 13 ], m_Data[ 14 ], m_Data[ 15 ] );
#endif

    return pOutString;
}

} // namespace detail
} // namespace viewer
} // namespace vfx
} // namespace nn
