﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vfx/viewer/vfx_CmdReceiver.h>

namespace nn {
namespace vfx {
namespace viewer {
namespace detail {

CommandReceiver* CommandReceiver::g_pCommandReceiver = NULL;

//------------------------------------------------------------------------------
//  コマンド受信クラスを生成する
//------------------------------------------------------------------------------
CommandReceiver* CreateCommandReceiver( nn::vfx::Heap* pHeap ) NN_NOEXCEPT
{
    if( CommandReceiver::g_pCommandReceiver )
    {
        return CommandReceiver::g_pCommandReceiver;
    }

    void* buffer = pHeap->Alloc( sizeof( CommandReceiver ) );
    CommandReceiver* ret = new ( buffer )CommandReceiver( pHeap );
    return ret;
}

//------------------------------------------------------------------------------
//  コマンド受信クラスを破棄する
//------------------------------------------------------------------------------
void DestroyCommandReceiver( nn::vfx::Heap* pHeap ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pHeap );
    CommandReceiver::g_pCommandReceiver->~CommandReceiver();
    if( CommandReceiver::g_pCommandReceiver )
    {
        pHeap->Free( CommandReceiver::g_pCommandReceiver );
    }
    CommandReceiver::g_pCommandReceiver = NULL;
}

//---------------------------------------------------------------------------
//  コンストラクタ
//---------------------------------------------------------------------------
CommandReceiver::CommandReceiver( nn::vfx::Heap* pHeap ) NN_NOEXCEPT
    : m_EffectIterator( m_EffectCommandQueue.Begin() ),
      m_Mutex(true)
{
    m_pHeap = pHeap;
    g_pCommandReceiver = this;
    m_IsLocked = false;
    m_EffectIterator = m_TempEffectCommandQueue.End();
}

//---------------------------------------------------------------------------
//  デストラクタ
//---------------------------------------------------------------------------
CommandReceiver::~CommandReceiver() NN_NOEXCEPT
{
    // 未実行のコマンドを削除
    while( GetEffectCommand() )
    {
        PopEffectCommand();
    }
}

//------------------------------------------------------------------------------
//  受信用プロシジャー
//------------------------------------------------------------------------------
void CommandReceiver::ReceiveProc( const void* pData, size_t size ) NN_NOEXCEPT
{
    g_pCommandReceiver->Lock();
    {
        // カテゴリを見て、ビューアコマンドとエフェクトコマンドを分岐させる
        const Message* pHeader = reinterpret_cast< const Message* >( pData );
        Message     header = ( *pHeader );
        uint32_t         index = 0;
        const uint8_t*   pPacketBuff = reinterpret_cast< const uint8_t* >( pHeader );

        while( header.bufferSize > 0 && index < size )
        {
            uint32_t szPacket = static_cast< uint32_t >( sizeof( Message ) + header.bufferSize );

            // 受信したエフェクトコマンドを追加
            g_pCommandReceiver->AddEffectCommand( CommandReceiverSettings_CommandId, pHeader, szPacket );

            // コールバックの呼び出し
            // gCmdReceiver->DoCallbackBeforeProc( header, pBody );

            // 次のパケットへ
            index += szPacket;
            pHeader = reinterpret_cast< const Message* >( &pPacketBuff[ index ] );
            header = ( *pHeader );
        }
    }
    g_pCommandReceiver->Unlock();
}

} // namespace detail
} // namespace viewer
} // namespace vfx
} // namespace nn
