﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_StringUtil.h>

#include <nn/ui2d/viewer/ui2d_FindableArcResourceAccessor.h>
#include <nn/ui2d/ui2d_Resources.h>

#if defined(NN_UI2D_VIEWER_ENABLED)

namespace nn
{
namespace ui2d
{
namespace viewer
{

bool FindableArcResourceAccessor::Attach(void* archiveStart, const char* resourceRootDirectory)
{
    if (nn::ui2d::ArcResourceAccessor::Attach(archiveStart, resourceRootDirectory))
    {
        m_FindArcHandle.GetArcExtractor()->PrepareArchive(archiveStart);
        return true;
    }
    else
    {
        return false;
    }
}

const char* FindableArcResourceAccessor::FindFile(nn::ui2d::ResType resType, const char* pPrevFileName)
{
    char tempBuf[FileNameMax];
    if (pPrevFileName)
    {
        const size_t lengthOfSlash = 1;
        nn::util::Strlcpy(tempBuf, "/", FileNameMax);
        std::strncat(tempBuf, pPrevFileName, FileNameMax - lengthOfSlash - 1); // -1 は終端文字の分
    }

    char resTypeStr[6];
    resTypeStr[0] = uint8_t (resType >> 24);
    resTypeStr[1] = uint8_t (resType >> 16);
    resTypeStr[2] = uint8_t (resType >>  8);
    resTypeStr[3] = uint8_t (resType >>  0);
    resTypeStr[4] = '/';
    resTypeStr[5] = 0;

    int  dir = 0;
    nn::ui2d::ArcEntry dirEntry;

    while (m_FindArcHandle.GetArcExtractor()->ReadEntry(&dir, &dirEntry, 1))
    {
        if (pPrevFileName)
        {
            const char* substr = std::strstr(dirEntry.name, tempBuf);
            if (substr)
            {
                pPrevFileName = NULL;
            }
        }
        else
        {
            const char* substr = std::strstr(dirEntry.name, resTypeStr);
            if (substr)
            {
                // 指定されたresTypeのファイルが見つかった
                nn::util::Strlcpy(m_FileNameBuffer, substr + std::strlen(resTypeStr), FileNameMax);
                return m_FileNameBuffer;
            }
        }
    }

    return NULL;
}

} // namespace viewer
} // namespace ui2d
} // namespace nn

#endif // NN_UI2D_VIEWER_ENABLED
