﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ui2d/ui2d_Types.h>
#include <nn/ui2d/ui2d_Layout.h>

namespace nn {
namespace ui2d {

void RenderTargetTextureInfo::Initialize(nn::gfx::Device* pDevice, const nn::gfx::TextureInfo& infoType, RenderTargetTextureLifetime lifetimeHint)
{
    Initialize(pDevice, NULL, infoType, lifetimeHint);
}

void RenderTargetTextureInfo::Initialize(nn::gfx::Device* pDevice, const Layout* pLayout, const nn::gfx::TextureInfo& infoType, RenderTargetTextureLifetime lifetimeHint)
{
    NN_SDK_ASSERT_NOT_NULL(Layout::GetCreateRenderTargetTextureResourceCallback());
    NN_SDK_ASSERT(nn::gfx::GpuAccess_ColorBuffer & infoType.GetGpuAccessFlags());
    NN_SDK_ASSERT(infoType.GetArrayLength() == 0);

    m_pOwnerLayout = pLayout;

    m_LifeTime = (*Layout::GetCreateRenderTargetTextureResourceCallback())(&m_pTexture, &m_pTextureView, &m_pTextureSlot, m_pOwnerLayout, infoType, Layout::GetRenderTargetTextureCallbackUserData(), lifetimeHint);

    NN_SDK_ASSERT_NOT_NULL(m_pTexture);
    NN_SDK_ASSERT_NOT_NULL(m_pTextureView);
    NN_SDK_ASSERT_NOT_NULL(m_pTextureSlot);

    // 基底クラスの DescriptorSlot の内容をコピーする。
    *(GetTextureDescriptorSlot()) = *m_pTextureSlot;

    // ColorTargetView
    {
        nn::gfx::ColorTargetView::InfoType targetViewInfo;
        targetViewInfo.SetDefault();
        targetViewInfo.SetImageDimension(nn::gfx::ImageDimension_2d);
        targetViewInfo.EditArrayRange().SetArrayLength(1);
        targetViewInfo.EditArrayRange().SetBaseArrayIndex(0);
        targetViewInfo.SetImageFormat(infoType.GetImageFormat());
        targetViewInfo.SetTexturePtr(m_pTexture);
        m_ColorTargetView.Initialize(pDevice, targetViewInfo);
    }

    // ViewportScissorState
    {
        nn::gfx::ViewportScissorState::InfoType info;
        info.SetDefault();
        info.SetScissorEnabled(true);
        nn::gfx::ViewportStateInfo viewportInfo;
        {
            viewportInfo.SetDefault();
            viewportInfo.SetOriginX(static_cast<float>(0));
            viewportInfo.SetOriginY(static_cast<float>(0));
            viewportInfo.SetWidth(static_cast<float>(infoType.GetWidth()));
            viewportInfo.SetHeight(static_cast<float>(infoType.GetHeight()));
        }
        nn::gfx::ScissorStateInfo scissorInfo;
        {
            scissorInfo.SetDefault();
            scissorInfo.SetOriginX(0);
            scissorInfo.SetOriginY(0);
            scissorInfo.SetWidth(infoType.GetWidth());
            scissorInfo.SetHeight(infoType.GetHeight());
        }
        info.SetViewportStateInfoArray(&viewportInfo, 1);
        info.SetScissorStateInfoArray(&scissorInfo, 1);

        m_ViewportScissorState.Initialize(pDevice, info);
    }

    SetSize(infoType.GetWidth(), infoType.GetHeight());

    m_Format = infoType.GetImageFormat();
}

void RenderTargetTextureInfo::Finalize(nn::gfx::Device* pDevice)
{
    NN_SDK_ASSERT_NOT_NULL(Layout::GetDestroyRenderTargetTextureResourceCallback());

    if (IsValid())
    {
        m_ViewportScissorState.Finalize(pDevice);
        m_ColorTargetView.Finalize(pDevice);

        (*Layout::GetDestroyRenderTargetTextureResourceCallback())(m_pTexture, m_pTextureView, m_pTextureSlot, m_pOwnerLayout, Layout::GetRenderTargetTextureCallbackUserData(), m_LifeTime);
        m_pTexture = NULL;
        m_pTextureView = NULL;
        m_pTextureSlot = NULL;

        m_Format = nn::gfx::ImageFormat_Undefined;
    }
}

} // namespace nn::ui2d
} // namespace nn
