﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_FormatString.h>

#include <nn/gfx/gfx_ResTexture.h>
#include <nn/ui2d/ui2d_Layout.h>
#include <nn/ui2d/ui2d_ResourceAccessor.h>
#include <nn/ui2d/ui2d_Resources.h>
#include <nn/ui2d/ui2d_Util.h>
#include <nn/ui2d/detail/ui2d_Log.h>
#include <nn/font/font_ResFont.h>

namespace nn
{
namespace ui2d
{

const char* ResourceAccessor::ArchiveShaderPrefix = "ArchiveShader";
const char* ResourceAccessor::ArchiveShaderSuffix = ".bnsh";

//----------------------------------------
ResourceAccessor::~ResourceAccessor()
{
}

//----------------------------------------
ResourceAccessor::ResourceAccessor()
{
}

//----------------------------------------
nn::font::Font*
ResourceAccessor::LoadFont(nn::gfx::Device* pDevice, const char *pName)
{
    size_t size = 0;
    void* pFontRes = this->FindResourceByName(&size, ResourceTypeFont, pName);
    if (!pFontRes || size == 0)
    {
        NN_DETAIL_UI2D_ERROR("font resource not found. - %s", pName);
        return NULL;
    }

    nn::font::ResFont* pResFont = Layout::AllocateAndConstruct<nn::font::ResFont>();
    if (pResFont == NULL)
    {
        NN_DETAIL_UI2D_ERROR("font object creation failed.");
        return NULL;
    }

    bool bSuccess = pResFont->SetResource(pDevice, pFontRes);
    if (!bSuccess)
    {
        NN_DETAIL_UI2D_ERROR("Fail to load ResFont.");
        Layout::DeleteObj(pResFont);
        return NULL;
    }

    return pResFont;
}

//----------------------------------------
void
ResourceAccessor::Finalize(nn::gfx::Device* pDevice)
{
    NN_UNUSED(pDevice);
}

} // namespace nn::ui2d
} // namespace nn
