﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ui2d/ui2d_ProfileHelper.h>

#include <nn/ui2d/ui2d_Layout.h>
#include <nn/ui2d/ui2d_Picture.h>
#include <nn/ui2d/ui2d_Window.h>
#include <nn/ui2d/ui2d_TextBox.h>
#include <nn/ui2d/ui2d_Bounding.h>
#include <nn/ui2d/ui2d_Parts.h>

namespace nn
{
namespace ui2d
{

//----------------------------------------
int
ProfileHelper::GetQuantityOfGroup(const Layout& layout)
{
    return layout.GetGroupContainer()->GetGroupList().size();
}

//----------------------------------------
int
ProfileHelper::GetQuantityOfAllPane(const nn::ui2d::Pane* pPane)
{
    if (pPane == NULL) { return 0; }

    int quantity = 1;

    const nn::ui2d::PaneList& children = pPane->GetChildList();
    for (nn::ui2d::PaneList::const_iterator child = children.begin();
        child != children.end(); ++child)
    {
        quantity += GetQuantityOfAllPane(&(*child));
    }
    return quantity;
}

//----------------------------------------
int
ProfileHelper::GetQuantityOf(nn::ui2d::PaneType paneType, const nn::ui2d::Pane* pPane)
{
    if (pPane == NULL) { return 0; }

    int quantity;
    switch (paneType)
    {
    case nn::ui2d::PaneType_Null:
        quantity = (IsTypeOf<nn::ui2d::Pane>(pPane)) ? 1 : 0;
        break;
    case nn::ui2d::PaneType_Picture:
        quantity = (IsTypeOf<nn::ui2d::Picture>(pPane)) ? 1 : 0;
        break;
    case nn::ui2d::PaneType_Window:
        quantity = (IsTypeOf<nn::ui2d::Window>(pPane)) ? 1 : 0;
        break;
    case nn::ui2d::PaneType_TextBox:
        quantity = (IsTypeOf<nn::ui2d::TextBox>(pPane)) ? 1 : 0;
        break;
    case nn::ui2d::PaneType_Bounding:
        quantity = (IsTypeOf<nn::ui2d::Bounding>(pPane)) ? 1 : 0;
        break;
    case nn::ui2d::PaneType_Parts:
        quantity = (IsTypeOf<nn::ui2d::Parts>(pPane)) ? 1 : 0;
        break;
    default:
        quantity = 0;
        break;
    }

    const nn::ui2d::PaneList& children = pPane->GetChildList();
    for (nn::ui2d::PaneList::const_iterator child = children.begin();
        child != children.end(); ++child)
    {
        quantity += GetQuantityOf(paneType, &(*child));
    }

    return quantity;
}

} // namespace ui2d
} // namespace nn

