﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../../precompiled.h"

#include <nn/spy/detail/fnd/basis/spyfnd_Time.h>

namespace nn {
namespace spy {
namespace detail {
namespace fnd {

//----------------------------------------------------------
TimeSpan
Time::Current() NN_NOEXCEPT
{
    return TimeSpan(OSGetSystemTime());
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromNanoSeconds(int64_t value) NN_NOEXCEPT
{
    return TimeSpan(OSNanosecondsToTicks(value));
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromMicroSeconds(int64_t value) NN_NOEXCEPT
{
    return TimeSpan(OSMicrosecondsToTicks(value));
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromMilliSeconds(int64_t value) NN_NOEXCEPT
{
    return TimeSpan(OSMillisecondsToTicks(value));
}

//----------------------------------------------------------
int64_t
TimeSpan::ToNanoSeconds() const NN_NOEXCEPT
{
    return OSTicksToNanoseconds(m_TickSpan);
}

//----------------------------------------------------------
int64_t
TimeSpan::ToMicroSeconds() const NN_NOEXCEPT
{
    return OSTicksToMicroseconds(m_TickSpan);
}

//----------------------------------------------------------
int64_t
TimeSpan::ToMilliSeconds() const NN_NOEXCEPT
{
    return OSTicksToMilliseconds(m_TickSpan);
}

} // namespace nn::spy::detail::fnd
} // namespace nn::spy::detail
} // namespace nn::spy
} // namespace nn
