﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../../precompiled.h"

#include <nn/spy/detail/fnd/basis/spyfnd_Memory.h>

//#define FND_ENABLE_MEM_DEBUG

namespace nn {
namespace spy {
namespace detail {
namespace fnd {

NN_DEFINE_STATIC_CONSTANT(const int MemoryTraits::DefaultAlignment);

//---------------------------------------------------------------------------
void
FrameHeap::Initialize(void* buffer, size_t length) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(buffer);
    NN_SDK_ASSERT(length > 0);

    m_Buffer = buffer;
    m_BufferLength = length;
}

//---------------------------------------------------------------------------
void
FrameHeap::Finalize() NN_NOEXCEPT
{
    m_Buffer = NULL;
    m_BufferLength = 0;
}

//---------------------------------------------------------------------------
size_t
FrameHeap::GetFreeLength(int alignment/*= MemoryTraits::DefaultAlignment*/) const NN_NOEXCEPT
{
    if(!IsInitialized()) { return 0; }

    void* result = AddOffsetToPtr(m_Buffer, m_UsedLength, alignment);
    return m_BufferLength - GetOffsetFromPtr(m_Buffer, result);
}

//---------------------------------------------------------------------------
void*
FrameHeap::Allocate(size_t size, int alignment/*= MemoryTraits::DefaultAlignment*/) NN_NOEXCEPT
{
    NN_SDK_ASSERT(alignment > 0);

    if(!IsInitialized())
    {
        NN_ABORT("FrameHeap is not initialized.\n");
        return NULL;
    }

    if(size == 0)
    {
        return NULL;
    }

    void*  result = AddOffsetToPtr(m_Buffer, m_UsedLength, alignment);
    size_t newUsedLength = GetOffsetFromPtr(m_Buffer, result) + size;

    if(newUsedLength > m_BufferLength)
    {
        NN_DETAIL_SPY_WARN("[%s] out of memory.\n", NN_CURRENT_FUNCTION_NAME);
        return NULL;
    }

    m_UsedLength = newUsedLength;

    return result;
}

} // namespace nn::spy::detail::fnd
} // namespace nn::spy::detail
} // namespace nn::spy
} // namespace nn
