﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/ige/ige_UiService.h>
#include "detail/ige_Allocator.h"

namespace nn { namespace ige {

//! @briefprivate  コンストラクタです。
UiService::UiService() NN_NOEXCEPT
    : m_EditService()
{
}

//! @briefprivate  デストラクタです。
UiService::~UiService() NN_NOEXCEPT
{
    FinalizeUiService();
}

void UiService::Initialize(InitializeArg arg) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(arg.allocateFunc);
    NN_SDK_REQUIRES_NOT_NULL(arg.freeFunc);

    Finalize();

    EditService::InitializeArg editArg;
    editArg.portName = arg.portName;
    editArg.allocateFunc = arg.allocateFunc;
    editArg.freeFunc = arg.freeFunc;
    editArg.pAllocateUserData = arg.pAllocateUserData;
    editArg.pFreeUserData = arg.pFreeUserData;

    m_EditService.Initialize(editArg);
    m_pAllocator = m_EditService.m_pAllocator;

    InitializeFactory(m_pAllocator, &m_EditService);
}

bool UiService::IsInitialized() const NN_NOEXCEPT
{
    return m_EditService.IsInitialized();
}

void UiService::Finalize() NN_NOEXCEPT
{
    FinalizeUiService();
    FinalizeFactory();
}

void UiService::FinalizeUiService() NN_NOEXCEPT
{
    DeleteAll();
    m_pAllocator = NULL;
    m_EditService.Finalize();
}

bool UiService::Start() NN_NOEXCEPT
{
    return m_EditService.Start();
}

bool UiService::IsStarted() const NN_NOEXCEPT
{
    return m_EditService.IsStarted();
}

void UiService::Stop() NN_NOEXCEPT
{
    m_EditService.Stop();
}

bool UiService::IsConnected() const NN_NOEXCEPT
{
    return m_EditService.IsConnected();
}

const util::string_view& UiService::GetPortName() const NN_NOEXCEPT
{
    return m_EditService.GetPortName();
}

void UiService::Poll() NN_NOEXCEPT
{
    m_EditService.Poll();
}

void UiService::Update() NN_NOEXCEPT
{
    m_EditService.Update();
}

void UiService::Register(Node* pNode) NN_NOEXCEPT
{
    m_EditService.Register(pNode);
}

void UiService::Unregister(Node* pNode) NN_NOEXCEPT
{
    m_EditService.Unregister(pNode);
}

}} // namespace nn::ige
