﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_Mutex.h>
#include <nn/nn_SdkAssert.h>
#include "ige_ScopedLock.h"

namespace nn { namespace ige { namespace detail {

ScopedLock::ScopedLock(nn::os::Mutex* pMutex) NN_NOEXCEPT
    : m_pMutex(pMutex)
{
    NN_SDK_ASSERT_NOT_NULL(pMutex);
    m_pMutex->Lock();
}

ScopedLock::~ScopedLock() NN_NOEXCEPT
{
    m_pMutex->Unlock();
    m_pMutex = NULL;
}

}}}
