﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ige_Message.h"
#include <nn/ige/ige_Node.h>

namespace nn { namespace ige { namespace detail {

class NodeMessage : public SystemMessage
{
public:
    NodeMessage(
        NodeIdType id,
        NodeIdType parentId,
        NodeType nodeType,
        const util::string_view& typeName,
        const BufferView& metaData) NN_NOEXCEPT
        : m_Id(id)
        , m_ParentId(parentId)
        , m_NodeType(nodeType)
        , m_TypeName(typeName)
        , m_MetaData(metaData)
    {
    }

    virtual MessageType GetType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return MessageType_Node;
    }

    static bool IsTarget(MessageType type) NN_NOEXCEPT
    {
        return type == MessageType_Node;
    }

    static bool IsTarget(const BufferView& buffer) NN_NOEXCEPT
    {
        return IsTarget(GetMessageType(buffer));
    }

protected:
    virtual void WritePacket(BufferWriter* pWriter) const NN_NOEXCEPT NN_OVERRIDE
    {
        pWriter->Write(static_cast<uint32_t>(m_Id));
        pWriter->Write(static_cast<uint32_t>(m_ParentId));
        pWriter->Write(static_cast<int32_t>(m_NodeType));
        pWriter->Write(m_TypeName);
        pWriter->Write(m_MetaData);
    }

private:
    NodeIdType m_Id;
    NodeIdType m_ParentId;
    NodeType m_NodeType;
    util::string_view m_TypeName;
    BufferView m_MetaData;
};

}}} // namespace nn::ige::detail
