﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Allocator.h>

namespace nn { namespace ige { namespace detail {

class IgeMemoryResource : public nn::MemoryResource
{
public:
    IgeMemoryResource(
        const nn::AlignedAllocateFunctionWithUserData allocateFunc,
        const nn::FreeFunctionWithUserData freeFunc,
        void* pAllocateUserData,
        void* pFreeUserData) NN_NOEXCEPT
        : m_pAllocateFunc(allocateFunc)
        , m_pFreeFunc(freeFunc)
        , m_pAllocateUserData(pAllocateUserData)
        , m_pFreeUserData(pFreeUserData)
    {
        NN_SDK_REQUIRES_NOT_NULL(allocateFunc);
        NN_SDK_REQUIRES_NOT_NULL(freeFunc);
    }

    void Free(void* ptr) NN_NOEXCEPT
    {
        m_pFreeFunc(ptr, m_pFreeUserData);
    }

protected:

    void* do_allocate(std::size_t bytes, std::size_t alignment) NN_NOEXCEPT NN_OVERRIDE
    {
        return m_pAllocateFunc(bytes, alignment, m_pAllocateUserData);
    }

    void do_deallocate(void* ptr, std::size_t, std::size_t) NN_NOEXCEPT NN_OVERRIDE
    {
        m_pFreeFunc(ptr, m_pFreeUserData);
    }

    bool do_is_equal(const MemoryResource& other) const NN_NOEXCEPT NN_OVERRIDE
    {
        return this == &other;
    }

private:
    const AlignedAllocateFunctionWithUserData m_pAllocateFunc;
    const FreeFunctionWithUserData m_pFreeFunc;
    void* m_pAllocateUserData;
    void* m_pFreeUserData;
};

}}} // namespace nn::ige::detail
