﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkText.h>
#include <nn/ige/ige_Log.h>

#if defined(NN_SDK_BUILD_DEBUG)
#define NN_IGE_LOG( ... ) NN_DETAIL_IGE_INFO(__VA_ARGS__)
#else
#define NN_IGE_LOG( ... ) static_cast<void>(0)
#endif

#define NN_IGE_ERROR_LOG( ... ) NN_DETAIL_IGE_ERROR("Error: " __VA_ARGS__)

#define NN_IGE_WARNING_LOG( ... ) NN_DETAIL_IGE_WARN("Warning: " __VA_ARGS__)

// 内部実装の警告用マクロ
#if defined(NN_SDK_BUILD_DEBUG) | defined(NN_SDK_BUILD_DEVELOP)
#define NN_IGE_INTERNAL_WARNING( ... ) NN_DETAIL_IGE_WARN("Internal Warning: " __VA_ARGS__)
#else
#define NN_IGE_INTERNAL_WARNING( ... ) static_cast<void>(0)
#endif

#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
#define NN_DETAIL_IGE_CONFIG_DEBUG_LOG_ENABLED (1)
#else
#define NN_DETAIL_IGE_CONFIG_DEBUG_LOG_ENABLED (0)
#endif

#if NN_DETAIL_IGE_CONFIG_DEBUG_LOG_ENABLED
#define NN_IGE_DEBUG_PRINT( ... ) NN_DETAIL_IGE_INFO("Debug: " __VA_ARGS__);
#else
#define NN_IGE_DEBUG_PRINT( ... ) static_cast<void>(0)
#endif

#define NN_IGE_NOT_SUPPORTED() NN_SDK_ASSERT(0, "Not supported.\n")
