﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../g3d_ViewerDetailDefine.h"



#include "../g3d_Allocator.h"
#include <nn/g3d/detail/g3d_Inlines.h>

namespace nn { namespace g3d { namespace viewer { namespace detail {

class EditWorkBuffer
{
public:
    explicit EditWorkBuffer(nn::g3d::viewer::detail::Allocator* pAllocator, AllocateType type) NN_NOEXCEPT
        : m_pAllocator(pAllocator)
        , m_Alignment(nn::g3d::detail::Alignment_Default)
        , m_pWorkBuffer(nullptr)
        , m_WorkBufferSize(0)
        , m_AllocateType(type)
    {
        NN_G3D_VIEWER_ASSERT_NOT_NULL(pAllocator);
    }

    explicit EditWorkBuffer(nn::g3d::viewer::detail::Allocator* pAllocator, size_t alignment, AllocateType type) NN_NOEXCEPT
        : m_pAllocator(pAllocator)
        , m_Alignment(alignment)
        , m_pWorkBuffer(nullptr)
        , m_WorkBufferSize(0)
        , m_AllocateType(type)
    {
        NN_G3D_VIEWER_ASSERT_NOT_NULL(pAllocator);
    }

    ~EditWorkBuffer() NN_NOEXCEPT
    {
        Clear();
    }

    void Clear() NN_NOEXCEPT
    {
        NN_G3D_VIEWER_ASSERT_NOT_NULL(m_pAllocator);
        if (m_pWorkBuffer != nullptr)
        {
            m_pAllocator->Free(m_pWorkBuffer);
            m_pWorkBuffer = nullptr;
            m_WorkBufferSize = 0;
        }
    }

    void *GetWorkBufferPtr() NN_NOEXCEPT
    {
        return m_pWorkBuffer;
    }

    const void *GetWorkBufferPtr() const NN_NOEXCEPT
    {
        return m_pWorkBuffer;
    }

    template<typename T>
    T* GetWorkBufferPtr() NN_NOEXCEPT
    {
        return reinterpret_cast<T*>(m_pWorkBuffer);
    }

    template<typename T>
    const T* GetWorkBufferPtr() const NN_NOEXCEPT
    {
        return reinterpret_cast<const T*>(m_pWorkBuffer);
    }

    size_t GetSize() const NN_NOEXCEPT
    {
        return m_WorkBufferSize;
    }

    bool Resize(size_t size) NN_NOEXCEPT;

    bool Resize(size_t size, size_t alignment) NN_NOEXCEPT;

    void CopyFrom(const void* pBuffer, size_t size) NN_NOEXCEPT;

private:
    bool ResizeImpl(size_t size) NN_NOEXCEPT;

private:
    nn::g3d::viewer::detail::Allocator* m_pAllocator;
    size_t m_Alignment;
    void*   m_pWorkBuffer;
    size_t m_WorkBufferSize;
    AllocateType m_AllocateType;
};

}}}} // namespace nn::g3d::viewer::detail


