﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>



#include "../util/g3d_SynchronizedFixedSizeArray.h"
#include "../util/g3d_EditWorkBuffer.h"
#include "../g3d_DeviceDependentObj.h"
#include "g3d_EditShaderProgram.h"

namespace nn { namespace g3d {

struct ResShaderProgramData;
class ResShadingModel;
class ResShaderArchive;
struct ResShaderInfo;

namespace viewer {
namespace detail {

class Allocator;
class EditShaderArchive;

/**
    @briefprivate 編集対象シェーディングモデルクラスです。
 */
class EditShadingModel : public DeviceDependentObj
{
    friend class EditShaderArchive;
    friend void UpdateProgram(nn::g3d::ResShadingModel*, int);

public:
    explicit EditShadingModel(
        nn::gfx::Device* pDevice,
        Allocator* allocator,
        ViewerKeyType shaderArchiveKey,
        int shadingModelIndex,
        ResShadingModel* resShadingModel,
        EditShaderArchive* editShaderArchive) NN_NOEXCEPT;

    bool Init() NN_NOEXCEPT;
    void ResetToOriginal() NN_NOEXCEPT;
    void Destroy() NN_NOEXCEPT;

    EditShaderProgram* GetEditShaderProgram(int programIndex) NN_NOEXCEPT
    {
        return m_ShaderProgramArray.UnsafeAt(programIndex);
    }

    int GetEditShaderProgramCount() const NN_NOEXCEPT
    {
        return m_ShaderProgramArray.GetCount();
    }

    const EditShaderArchive* GetEditShaderArchive() const NN_NOEXCEPT
    {
        return m_pEditShaderArchive;
    }

    void UpdateShadingModel(ResShaderArchive* resShaderArchive) NN_NOEXCEPT;

    ResShadingModel* GetTargetShadingModel() NN_NOEXCEPT
    {
        return m_pTargetResShadingModel;
    }

    const ResShadingModel* GetTargetShadingModel() const NN_NOEXCEPT
    {
        return m_pTargetResShadingModel;
    }

    ResShaderInfo* GetOriginalShaderInfo() NN_NOEXCEPT
    {
        return m_pOriginalShaderInfo;
    }

    const ResShaderInfo* GetOriginalShaderInfo() const NN_NOEXCEPT
    {
        return m_pOriginalShaderInfo;
    }

    void SendModifiedShaderPrograms(EditSocketBase* pSocket) NN_NOEXCEPT;

private:
    ResShadingModel*                                    m_pTargetResShadingModel;
    SynchronizedFixedSizeArray<EditShaderProgram>     m_ShaderProgramArray;
    ViewerKeyType                                                 m_ShaderArchiveKey;
    int                                                 m_ShadingModelIndex;
    const EditShaderArchive*                            m_pEditShaderArchive;

    ResShaderInfo* m_pOriginalShaderInfo;
    ResShadingModel* m_pUpdateResShadingModel;

    NN_DISALLOW_COPY(EditShadingModel);
};

}} // nn::g3d::viewer::detail
}} // namespace nw::g3d


