﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>

#include "../util/g3d_SynchronizedFixedSizeArray.h"
#include "../util/g3d_EditWorkBuffer.h"
#include "g3d_EditShadingModel.h"
#include "../g3d_DeviceDependentObj.h"
#include "../util/g3d_ViewerUtility.h"

#include <nn/g3d/g3d_ResShader.h>

namespace nn { namespace g3d {

class ResShaderArchive;

namespace viewer {

namespace detail {

class Allocator;
class EditSocketBase;

/**
    @briefprivate 編集対象シェーダアーカイブクラスです。
 */
class EditShaderArchive : public DeviceDependentObj
{
public:
    explicit EditShaderArchive(nn::gfx::Device* pDevice, Allocator* allocator, ResShaderArchive* resShaderArchive) NN_NOEXCEPT;

    /**
        @briefprivate 指定されたResShaderArchiveに対してアタッチ処理を行います。
     */
    bool Attach() NN_NOEXCEPT;

    /**
        @briefprivate アタッチしたResShaderArchiveを元に戻します。
     */
    void Detach() NN_NOEXCEPT;

    const ResShaderArchive* GetTargetResShaderArchive() const NN_NOEXCEPT
    {
        return m_pTargetResShaderArchive;
    }

    ResShaderArchive* GetTargetResShaderArchive() NN_NOEXCEPT
    {
        return m_pTargetResShaderArchive;
    }

    void CallOriginalUpdateCallback(ResShadingModel*pResShadingModel, int programIndex) const NN_NOEXCEPT
    {
        m_pOriginalUpdateProgramCallback(m_pDevice, pResShadingModel, programIndex);
    }

    void UpdateShaderProgram(int shadingModelIndex, int shaderProgramIndex, ResShaderArchive* pNewResShaderArchive) NN_NOEXCEPT;
    void UpdateShadingModels(int shadingModelIndices[], int indexCount) NN_NOEXCEPT;
    void SendModifiedShaderPrograms(EditSocketBase* socket) NN_NOEXCEPT;

    EditShadingModel* GetEditShadingModel(int index = 0) NN_NOEXCEPT
    {
        return m_ShadingModelArray.UnsafeAt(index);
    }

    const EditShadingModel* GetEditShadingModel(int index = 0) const NN_NOEXCEPT
    {
        return m_ShadingModelArray.UnsafeAt(index);
    }

    int GetEditShadingModelCount() const NN_NOEXCEPT
    {
        return m_ShadingModelArray.GetCount();
    }

private:
    void ResetToOriginal() NN_NOEXCEPT;
    void Destroy() NN_NOEXCEPT;

    void DestroyShadingModels() NN_NOEXCEPT;

private:
    ResShaderArchive* m_pTargetResShaderArchive;
    SynchronizedFixedSizeArray<EditShadingModel> m_ShadingModelArray;
    UpdateProgramCallback m_pOriginalUpdateProgramCallback;

    NN_DISALLOW_COPY(EditShaderArchive);
};

}} // nn::g3d::viewer::detail
}} // namespace nw::g3d


