﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_ViewerKeyManager.h"



#include <new>

using namespace nn::g3d::viewer::detail;

namespace {
    static ViewerKeyManager* s_pInstance;
}

void ViewerKeyManager::Initialize(Allocator* pAllocator) NN_NOEXCEPT
{
    NN_G3D_VIEWER_ASSERT_NOT_NULL(pAllocator);

    void* buffer = pAllocator->Allocate(sizeof(ViewerKeyManager), Alignment_Default, AllocateType_Other);
    NN_G3D_VIEWER_ASSERT_NOT_NULL(buffer);
    s_pInstance = new (buffer) ViewerKeyManager(pAllocator);
}

ViewerKeyManager& ViewerKeyManager::GetInstance() NN_NOEXCEPT
{
    return *s_pInstance;
}

void ViewerKeyManager::Finalize() NN_NOEXCEPT
{
    Allocator* pAllocator = s_pInstance->m_pAllocator;
    s_pInstance->~ViewerKeyManager();
    pAllocator->Free(s_pInstance);
    s_pInstance = nullptr;
}

bool ViewerKeyManager::IsInitialized() NN_NOEXCEPT
{
    return s_pInstance != nullptr;
}


