﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditSocket.h"



#include "g3d_ViewerDetailDefine.h"

#include <nn/ige/ige_HtcsHelper.h>

namespace nn { namespace g3d { namespace viewer { namespace detail {


EditSocketBase::EditSocketBase() NN_NOEXCEPT
    : m_WriteBufferSize(0)
    , m_ReadBufferSize(0)
    , m_WriteSize(0)
    , m_WritingSize(0)
    , m_TotalWritingSize(0)
    , m_ReadSize(0)
    , m_ReadingSize(0)
    , m_TotalReadingSize(0)
    , m_IsWriteEnd(true)
    , m_IsReadEnd(true)
    , m_IsOpenRequested(false)
    , m_IsOpened(false)
    , m_IsWriteLogEnabled(false)
    , m_pWriteBuffer(nullptr)
    , m_pReadBuffer(nullptr)
{
}

EditSocketBase::~EditSocketBase() NN_NOEXCEPT
{
}

bool
EditSocketBase::WriteSync(void* buf, size_t size) NN_NOEXCEPT
{
    bool result = WriteASync(buf, size);

    size_t oldWriteSize = m_WritingSize;

    if (size != oldWriteSize)
    {
        result = false;
    }

    do
    {
        if (!IsConnected())
        {
            break;
        }

        WriteASyncForPoll();

        if (!IsWriting())
        {
            result = true;
            break;
        }
    } while (!result);

    size_t writeSize = m_WritingSize;
    if (size != writeSize)
    {
        result = false;
    }
    return result;
}

bool EditSocketBase::WriteASync(void* buf, size_t size) NN_NOEXCEPT
{
    NN_G3D_VIEWER_ASSERT_NOT_NULL( buf );
    NN_G3D_VIEWER_ASSERT( size != 0 );

    if (IsWriting())
    {
        return false;
    }

    if (!m_IsWriteEnd)
    {
        return false;
    }

    return WriteASyncInternal(buf, size);
}

bool EditSocketBase::ReadASync(void* buf, size_t size) NN_NOEXCEPT
{
    NN_G3D_VIEWER_ASSERT_NOT_NULL(buf);
    NN_G3D_VIEWER_ASSERT(size != 0);

    if (IsReading())
    {
        return false;
    }

    if (!m_IsReadEnd)
    {
        return false;
    }

    return ReadASyncInternal(buf, size);
}



}}}} // namespace nn::g3d::viewer::detail


