﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>



#include "g3d_Allocator.h"
#include <nn/gfx/gfx_Core.h>
#include <nn/gfx/gfx_Types.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace g3d {
namespace viewer { namespace detail {

    class DeviceDependentObj
    {
    public:
        DeviceDependentObj(nn::gfx::Device* pDevice, Allocator* pAllocator) NN_NOEXCEPT
            : m_pDevice(pDevice)
            , m_pAllocator(pAllocator)
        {
            NN_SDK_REQUIRES_NOT_NULL(pDevice);
            NN_SDK_REQUIRES_NOT_NULL(pAllocator);
        }

        virtual ~DeviceDependentObj() NN_NOEXCEPT
        {
        }

    protected:
        nn::gfx::Device* m_pDevice;
        Allocator* m_pAllocator;
    };

}}}}

