﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerServer.h>
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>
#include "g3d_IViewerCommand.h"
#include "g3d_CommandTypes.h"

namespace nn { namespace g3d { namespace viewer { namespace detail {
    class Allocator;
    struct MessageNotificationPacket;

    class NotifyMessageCommand : public IViewerCommand
    {
    public:
        NotifyMessageCommand(
            Allocator* pAllocator,
            const nn::util::string_view& message,
            int messageCodePage,
            MessageType messageType,
            ViewerServer::SendUserMessageArg::MessageDestination messageDestination) NN_NOEXCEPT;
        ~NotifyMessageCommand() NN_NOEXCEPT;

        virtual int Type() const NN_NOEXCEPT
        {
            return CommandType_UserMessage;
        }

        virtual CommandResult Execute(EditSocketBase* pSocket) NN_NOEXCEPT;

    private:
        Allocator* m_pAllocator;
        MessageNotificationPacket* m_pMessageNotificationPacket;
        size_t m_PacketSize;
    };
}}}}
