﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_LayoutModelCommand.h"

#include "../g3d_EditSocket.h"
#include "../g3d_ViewerDetailDefine.h"
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>
#include "../util/g3d_ViewerUtility.h"

using namespace nn::g3d::viewer::detail;

nn::g3d::viewer::detail::LayoutModelCommand::LayoutModelCommand(
    ViewerKeyType modelKey,
    const nn::util::Vector3fType& scale,
    const nn::util::Vector3fType& rotate,
    const nn::util::Vector3fType& translate) NN_NOEXCEPT
{
    m_ModelLayoutPacket.header.command = EDIT_SEND_MODEL_LAYOUT_COMMAND_FLAG;
    m_ModelLayoutPacket.header.dataSize = sizeof(ModelLayoutEditBlock);
    m_ModelLayoutPacket.header.magic = NN_G3D_EDIT_MAGIC;
    m_ModelLayoutPacket.header.verWord = NN_G3D_EDIT_VERSION;

    memset(&m_ModelLayoutPacket.block, 0, sizeof(m_ModelLayoutPacket.block));
    m_ModelLayoutPacket.block.modelKey = modelKey;

    m_ModelLayoutPacket.block.scale.x = nn::util::VectorGetX(scale);
    m_ModelLayoutPacket.block.scale.y = nn::util::VectorGetY(scale);
    m_ModelLayoutPacket.block.scale.z = nn::util::VectorGetZ(scale);

    m_ModelLayoutPacket.block.rotate.x = nn::util::VectorGetX(rotate);
    m_ModelLayoutPacket.block.rotate.y = nn::util::VectorGetY(rotate);
    m_ModelLayoutPacket.block.rotate.z = nn::util::VectorGetZ(rotate);

    m_ModelLayoutPacket.block.translate.x = nn::util::VectorGetX(translate);
    m_ModelLayoutPacket.block.translate.y = nn::util::VectorGetY(translate);
    m_ModelLayoutPacket.block.translate.z = nn::util::VectorGetZ(translate);

    NN_G3D_VIEWER_DEBUG_PRINT("ModelLayoutEdit CommandQueue : %s [%d:%x]\n",
        GetEditCommandString(static_cast<CommandFlag>(m_ModelLayoutPacket.header.command)),
        m_ModelLayoutPacket.block.isBind,
        m_ModelLayoutPacket.block.modelKey);
}

nn::g3d::viewer::detail::LayoutModelCommand::~LayoutModelCommand() NN_NOEXCEPT
{
}

CommandResult nn::g3d::viewer::detail::LayoutModelCommand::Execute(EditSocketBase* pSocket) NN_NOEXCEPT
{
    NN_G3D_VIEWER_DEBUG_PRINT("Write LayoutModelCommand\n");
    if (!pSocket->WriteSync(&m_ModelLayoutPacket, sizeof(m_ModelLayoutPacket)))
    {
        return CommandResult_Failed;
    }

    return CommandResult_Success;
}
