﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditVisibilityAnimObj.h"



#include "g3d_EditAnimCurve.h"
#include "../g3d_Allocator.h"

namespace {
    void ClearBoneVisibleImpl(nn::g3d::ModelObj* pModelObj, void*) NN_NOEXCEPT
    {
        pModelObj->ClearBoneVisible();
    }

    void ClearMaterialVisibleImpl(nn::g3d::ModelObj* pModelObj, void*) NN_NOEXCEPT
    {
        pModelObj->ClearMaterialVisible();
    }
}

namespace nn { namespace g3d { namespace viewer { namespace detail {

    /*virtual*/void
        EditVisibilityAnimObj::DestroyDataForEditingAnimCurve() NN_NOEXCEPT
    {
        for(int i = 0; i < m_EditAnimCurveCount; ++i)
        {
            EditAnimCurve* editAnimCurve = &m_pEditAnimCurveArray[i];
            editAnimCurve->Cleanup();
            editAnimCurve->~EditAnimCurve();
        }

        m_EditAnimCurveCount = 0;
        if (m_pEditAnimCurveArray != nullptr)
        {
            m_pAllocator->Free(m_pEditAnimCurveArray);
            m_pEditAnimCurveArray = nullptr;
        }
    }

    /*virtual*/void
        EditBoneVisibilityAnimObj::ResetToOriginalValue(EditModelObj* pBoundModelObj) NN_NOEXCEPT
    {
        if (!IsModelBound(pBoundModelObj))
        {
            return;
        }

        pBoundModelObj->ExecuteFunctionForeachInstance(ClearBoneVisibleImpl);
    }

    /*virtual*/void
        EditMatVisibilityAnimObj::ResetToOriginalValue(EditModelObj* pBoundModelObj) NN_NOEXCEPT
    {
        if (!IsModelBound(pBoundModelObj))
        {
            return;
        }

        pBoundModelObj->ExecuteFunctionForeachInstance(ClearMaterialVisibleImpl);
        pBoundModelObj->UpdateMaterialVisible();
    }
}}}}

