﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_VolumeThroughModePacket.h>
namespace nn { namespace atk { namespace detail {

size_t VolumeThroughModePacket::GetRequiredMemSize(int busCount) NN_NOEXCEPT
{
    size_t result = VolumeThroughModeArray::GetRequiredMemSize(busCount);
    // TODO: メモリアロケーション処理の正式対応
    result = nn::util::align_up(result, 8);
    return result;
}

bool VolumeThroughModePacket::Initialize(void * buffer, size_t size, int busCount) NN_NOEXCEPT
{
    return m_VolumeThroughMode.Initialize(buffer, size, busCount);
}

void VolumeThroughModePacket::Finalize() NN_NOEXCEPT
{
    m_VolumeThroughMode.Finalize();
    m_IsVolumeThroughModeUsed = false;
    m_BinaryVolume = 1.0f;
}

void VolumeThroughModePacket::Reset() NN_NOEXCEPT
{
    m_VolumeThroughMode.Reset();
    m_IsVolumeThroughModeUsed = false;
    m_BinaryVolume = 1.0f;
}

VolumeThroughModePacket& VolumeThroughModePacket::operator=(const VolumeThroughModePacket& rhs) NN_NOEXCEPT
{
    m_VolumeThroughMode = rhs.m_VolumeThroughMode;
    m_IsVolumeThroughModeUsed = rhs.m_IsVolumeThroughModeUsed;
    m_BinaryVolume = rhs.m_BinaryVolume;
    return *this;
}

}}}
