﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/detail/atk_AdvancedWaveSoundFile.h>

#include <nn/atk/atk_ElementType.h>
#include <nn/util/util_BytePtr.h>

namespace nn { namespace atk { namespace detail {

    const AdvancedWaveSoundFile::InfoBlock* AdvancedWaveSoundFile::GetBlock() const NN_NOEXCEPT
    {
        return reinterpret_cast<const AdvancedWaveSoundFile::InfoBlock*>(fileHeader.GetFirstBlock());
    }

    const BinaryTypes::ReferenceTable& AdvancedWaveSoundFile::InfoBlockBody::GetTrackReferenceTable() const NN_NOEXCEPT
    {
        nn::util::ConstBytePtr bytePtr(this);
        bytePtr += offsetToTrackTableReference;

        return *reinterpret_cast<const BinaryTypes::ReferenceTable*>(bytePtr.Get());
    }

    const AdvancedWaveSoundFile::WaveSoundTrack&
    AdvancedWaveSoundFile::InfoBlockBody::GetWaveSoundTrack( int index ) const NN_NOEXCEPT
    {
        NN_SDK_ASSERT( index < GetTrackCount() );
        const void* pReferedItem = GetTrackReferenceTable().GetReferedItem(index);
        NN_SDK_ASSERT_NOT_NULL( pReferedItem );
        const WaveSoundTrack* pWaveSoundTrack = reinterpret_cast<const WaveSoundTrack*>( pReferedItem );
        NN_SDK_ASSERT_NOT_NULL( pWaveSoundTrack );

        return *pWaveSoundTrack;
    }

    const BinaryTypes::ReferenceTable& AdvancedWaveSoundFile::WaveSoundTrack::GetClipReferenceTable() const NN_NOEXCEPT
    {
        nn::util::ConstBytePtr bytePtr(this);
        bytePtr += offsetToClipTableReference;

        return *reinterpret_cast<const BinaryTypes::ReferenceTable*>(bytePtr.Get());
    }

    const AdvancedWaveSoundFile::WaveSoundClip&
    AdvancedWaveSoundFile::WaveSoundTrack::GetWaveSoundClip( int index ) const NN_NOEXCEPT
    {
        NN_SDK_ASSERT( index < GetClipCount() );
        const void* pReferedItem = GetClipReferenceTable().GetReferedItem(index);
        NN_SDK_ASSERT_NOT_NULL( pReferedItem );
        const WaveSoundClip* pWaveSoundClip = reinterpret_cast<const WaveSoundClip*>( pReferedItem );
        NN_SDK_ASSERT_NOT_NULL( pWaveSoundClip );

        return *pWaveSoundClip;
    }

}}} // namespace nn::atk::detail
