﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_StreamSoundHandle.h>
#include <nn/atk/atk_SoundHandle.h>

namespace nn {
namespace atk {

StreamSoundHandle::StreamSoundHandle( SoundHandle* pHandle ) NN_NOEXCEPT
: m_pSound( NULL )
{
    if ( pHandle == NULL ) return;

    // 汎用ハンドルからサウンドを取得
    if ( !pHandle->IsAttachedSound() ) return;

    detail::StreamSound* sound =
        detail::fnd::DynamicCast<detail::StreamSound*>( pHandle->detail_GetAttachedSound() );

    if ( sound != NULL )
    {
        // シーケンスサウンドなら一時ハンドルとしてAttachする
        detail_AttachSoundAsTempHandle( sound );
    }
}

/*--------------------------------------------------------------------------------*
  Name:         detail_AttachSoundAsTempHandle

  Description:  ハンドルにサウンドを関連付ける

  Arguments:    sound - 関連付けるサウンド

  Returns:      None.
 *--------------------------------------------------------------------------------*/
void StreamSoundHandle::detail_AttachSoundAsTempHandle( detail::StreamSound* pSound ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pSound );

    m_pSound = pSound;

    // 一時ハンドルとしてAttachする
    if ( m_pSound->IsAttachedTempSpecialHandle() )
    {
        m_pSound->DetachTempSpecialHandle();
    }
    m_pSound->m_pTempSpecialHandle = this;
}

/*--------------------------------------------------------------------------------*
  Name:         DetachSound

  Description:  ハンドルに結びついているサウンドの関連を外す

  Arguments:    None.

  Returns:      None.
 *--------------------------------------------------------------------------------*/
void StreamSoundHandle::DetachSound() NN_NOEXCEPT
{
    if ( IsAttachedSound() )
    {
        if ( m_pSound->m_pTempSpecialHandle == this ) m_pSound->m_pTempSpecialHandle = NULL;
    }
    if ( m_pSound != NULL ) m_pSound = NULL;
}

} // namespace nn::atk
} // namespace nn

