﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Mutex.h>

namespace nn { namespace atk2 { namespace detail { namespace fnd {

    //! @internal
    //! @brief クリティカルセクションです。内部では Mutex を使用しています。
    class CriticalSection
    {
    public:
        //! @brief コンストラクタです
        CriticalSection() NN_NOEXCEPT;
        //! @brief デストラクタです
        ~CriticalSection() NN_NOEXCEPT;

        //! @brief ロックを行います
        void Lock() NN_NOEXCEPT;
        //! @brief ロックを試みます
        bool TryLock() NN_NOEXCEPT;
        //! @brief ロックを解除します
        void Unlock() NN_NOEXCEPT;

    private:
        nn::os::Mutex m_Mutex;
    };

}}}}
