﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/atk2/detail/atk2_WaveBuffer.h>
#include <nn/atk2/detail/atk2_CommandManager.h>

namespace nn  { namespace atk2 {

    class AudioEngine;

namespace detail {


enum VoiceReplyCommandId
{
    VoiceReplyCommandId_WaveBufferUpdate,
};

struct VoiceReplyCommandWaveBuffer : public Command
{
    const void* tag;
    WaveBufferState status;
//    uint32_t playPosition;
};

// @brief レンダラボイスの変更をボイスに反映するためのコマンド処理を管理するクラスです
class VoiceReplyCommandManager : public CommandManager
{
public:
    // @brief 初期化に使用するパラメータです
    struct InitArg
    {
        int waveBufferPacketCount; //<! 波形バッファパケットの数です
        size_t commandBufferSize;  //<! コマンドバッファのサイズです
        void* workBuffer;          //<! ワークバッファです
        size_t workBufferSize;     //<! ワークバッファのサイズです

        AudioEngine* _pAudioEngine;
    };

    // @brief 初期化に使用するプラットフォーム固有のパラメータです
    struct PlatformInitArg
    {
        void* workBuffer;                   //!< ワークバッファです
        size_t workBufferSize;              //!< ワークバッファのサイズです
        void* workBufferForMemoryPool;      //!< メモリプールにアタッチされたワークバッファです
        size_t workBufferSizeForMemoryPool; //!< メモリプールにアタッチされたワークバッファのサイズです
    };

public:
    // @brief コンストラクタです
    VoiceReplyCommandManager() NN_NOEXCEPT;
    // @brief 初期化パラメータの初期値を取得します
    void GetDefaultInitArg(InitArg& arg, PlatformInitArg& platformArg) NN_NOEXCEPT;
    size_t GetRequiredBufferSize(const InitArg& arg, const PlatformInitArg& platformArg) NN_NOEXCEPT;
    void Initialize(InitArg& arg, PlatformInitArg& platformArg) NN_NOEXCEPT;
    void Initialize( void* commandBuffer, size_t commandBufferSize ) NN_NOEXCEPT;

private:
    virtual void ProcessCommandList( Command* commandList ) NN_NOEXCEPT NN_OVERRIDE;

private:
    void* m_CommandBuffer;
    size_t m_CommandBufferSize;

    AudioEngine* m_pAudioEngine;
};

}}}
