﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio/audio_Voice.h>

#include <nn/nn_SdkLog.h>
#include <nn/atk2/detail/atk2_Voice.h>
#include <nn/atk2/detail/atk2_WaveBuffer.h>
#include <nn/atk2/detail/atk2_WaveBufferList.h>

namespace nn { namespace audio {
    struct AdpcmParameter;
}}

namespace nn { namespace atk2 {

    class AudioEngine;

namespace detail {

    // @brief オーディオレンダラに紐づくボイスのクラスです
    class RendererVoice
    {
    public:
        // @brief 関数の処理結果を表す列挙体です
        enum Result
        {
            Result_Success = 0,              //!< 成功です
            Result_FailedToAppendWaveBuffer, //!< 波形バッファの追加に失敗しました
            Result_ErrorUnknown              //!< 不明なエラーです
        };

    public:
        // @brief コンストラクタです
        RendererVoice() NN_NOEXCEPT;
        // @brief 初期化を行います
        Result Initialize() NN_NOEXCEPT;
        // @brief 終了処理を行います
        void Finalize() NN_NOEXCEPT;
        // @brief 更新処理を行います
        Result Update() NN_NOEXCEPT;
        // @brief 波形バッファをリストに追加します
        Result AppendWaveBufferList(WaveBuffer* pWaveBuffer) NN_NOEXCEPT;
        // @brief 波形バッファのリストをクリアします
        Result ClearWaveBufferList() NN_NOEXCEPT;

        // @brief オーディオエンジンを設定します
        void SetAudioEngine(AudioEngine* pAudioEngine) NN_NOEXCEPT;
        // @brief ADPCM パラメータのバッファを設定します
        void SetAdpcmParameterBuffer(void* buffer) NN_NOEXCEPT;

        // VoiceCommand 用
        // @brief ボイスの情報を取得します
        void GetVoiceInfo(VoiceInfo* pOutVoiceInfo) NN_NOEXCEPT;
        // @brief ボイスを設定します
        void SetVoice(Voice* pVoice) NN_NOEXCEPT;
        // @brief サンプルレートを設定します
        void SetSampleRate(int sampleRate) NN_NOEXCEPT;
        // @brief サンプルフォーマットを設定します
        void SetSampleFormat(SampleFormat sampleFormat) NN_NOEXCEPT;
        // @brief  ADPCM パラメータを設定します
        void SetAdpcmParam(AdpcmParam* pAdpcmParam) NN_NOEXCEPT;
        // @brief ボイスの出力先を設定します
        void SetOutputReceiver(OutputReceiver* pOutputReceiver) NN_NOEXCEPT;


        // @brief ボイスの確保を行います
        bool AcquireVoiceSlot() NN_NOEXCEPT;
        // @brief ボイスの解放を行います
        void ReleaseVoiceSlot() NN_NOEXCEPT;
        // @brief ボイスのルーティング先を設定します
        void SetVoiceDestination() NN_NOEXCEPT;
        // @brief 優先度を設定します
        void SetVoicePriority(int priority) NN_NOEXCEPT;
        // @brief ピッチを設定します
        void SetVoicePitch(float pitch) NN_NOEXCEPT;
        // @brief 音量を設定します
        void SetVoiceVolume(float volume) NN_NOEXCEPT;
        // @brief ミックス時の音量を設定します
        void SetVoiceMixVolume(float volume, int sourceIndex, int destinationIndex) NN_NOEXCEPT;
        // @brief Biquad フィルタのパラメータを設定します
        void SetVoiceBiquadFilterParameter(int filterIndex) NN_NOEXCEPT;
        // @brief 再生状態を設定します
        void SetVoiceState(VoiceState state);
        // @brief ノード ID を取得します
        uint32_t GetNodeId() NN_NOEXCEPT;
        // @brief ボイスが有効かどうかを取得します
        bool IsAvailable() const NN_NOEXCEPT;
        // @brief ボイスが有効かどうかを設定します
        void SetAvailable(bool isAvailable) NN_NOEXCEPT;

    private:
        // 再生状態の更新用
        void UpdateVoicePlayState(bool* pOutPlayWaveBufferFlag) NN_NOEXCEPT;
        void UpdateWaveBuffer(bool playWaveBufferFlag) NN_NOEXCEPT;
        void AppendStockedWaveBuffer() NN_NOEXCEPT;
        void FreeReleasedWaveBuffer() NN_NOEXCEPT;
        void UpdatePlayPosition() NN_NOEXCEPT;
        Result AppendWaveBuffer(WaveBuffer* pWaveBuffer) NN_NOEXCEPT;
        void SetVoicePlayState(nn::audio::VoiceType::PlayState state) NN_NOEXCEPT;

    private:
        // 波形のメタデータ
        int m_SampleRate;
        SampleFormat m_SampleFormat;
        nn::audio::AdpcmParameter* m_pAdpcmParameter;

        // ボイスのパラメータ
        //float                    m_Volume;
        //float                    m_Pitch;
        //OutputMix                m_TvMix;
        //bool                     m_MonoFilterFlag;
        //bool                     m_BiquadFilterFlag;
        //BiquadFilterCoefficients m_BiquadFilterCoefficients;
        //uint16_t                 m_MonoFilterCutoff;     // LPF のカットオフ周波数
        //uint8_t                  m_InterpolationType;    // 補間タイプ
        int                      m_ChannelCount;
        int                      m_Priority;
        OutputReceiver*          m_pOutputReceiver;

        // 内部管理用変数
        nn::audio::VoiceType m_VoiceType;
        //nn::audio::NodeId  m_NodeId;
        VoiceState m_VoiceState;
        uint32_t m_PlayPosition;
        WaveBufferList m_WaveBufferList;
        WaveBuffer* m_LastAppendBuffer;
        //bool m_IsVoiceParamDirty;
        AudioEngine* m_pAudioEngine;
        Voice* m_pVoice;
        bool m_IsAvailable;

        bool m_IsNeedUpdateRenderer;
    };

}}}

