﻿using System;
using System.ComponentModel;
using SdkEnvironmentCheckerLibrary.Checkers;

namespace SdkEnvironmentCheckerLibrary.Serializers
{
    public class OsVersion
    {
        public string DisplayName { get; set; }

        [TypeConverter(typeof(VersionTypeConverter))]
        public Version Version { get; set; }

        public bool Is64BitOnly { get; set; }

        public OsVersionInfo ToCheckerInfo()
            => new OsVersionInfo(DisplayName ?? string.Empty, Version ?? new Version(), Is64BitOnly);
    }
}
