﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Windows.Markup;
using SdkEnvironmentCheckerLibrary.Checkers;

namespace SdkEnvironmentCheckerLibrary.Serializers
{
    [ContentProperty(nameof(RequiredVersions))]
    public class InstalledProgramVersion
    {
        public string DisplayName { get; set; }

        public string SearchPattern { get; set; }

        public IList<RequiredVersion> RequiredVersions { get; } = new NotNullList<RequiredVersion>();

        public InstalledProgramVersionInfo ToCheckerInfo()
            => new InstalledProgramVersionInfo(DisplayName ?? string.Empty, SearchPattern, RequiredVersions.Select(r => r.ToCheckerInfo(this)));
    }

    public class RequiredVersion
    {
        [TypeConverter(typeof(VersionTypeConverter))]
        public Version Version { get; set; }

        public MatchLevel MatchLevel { get; set; } = MatchLevel.All; // デフォルト値は完全一致にしておく

        public RequiredVersionInfo ToCheckerInfo()
        {
            var version = Version;
            if (version == null) throw new InvalidOperationException($"'{nameof(RequiredVersion)}' needs 'Version' value.");

            return new RequiredVersionInfo(version, MatchLevel);
        }

        internal RequiredVersionInfo ToCheckerInfo(InstalledProgramVersion parent)
        {
            if (parent == null) throw new ArgumentNullException(nameof(parent));

            var version = Version;
            if (version == null) throw new InvalidOperationException($"'{nameof(RequiredVersion)}' needs 'Version' in '{parent.DisplayName}'.");

            return new RequiredVersionInfo(version, MatchLevel);
        }
    }
}
