﻿using System;

namespace SdkEnvironmentCheckerLibrary
{
    /// <summary>
    /// プログラムのインストール情報です。
    /// </summary>
    public class ProgramInstallInfo
    {
        private readonly Version version;

        internal ProgramInstallInfo(string id, string displayName, string displayVersion)
        {
            Id = id;
            DisplayName = displayName ?? string.Empty;
            DisplayVersion = displayVersion ?? string.Empty;
            Version.TryParse(DisplayVersion, out version);
        }

        /// <summary>
        /// プログラムの ID を取得します。
        /// </summary>
        public string Id { get; }

        /// <summary>
        /// 表示名を取得します。
        /// </summary>
        public string DisplayName { get; }

        /// <summary>
        /// 表示バージョンを取得します。
        /// </summary>
        public string DisplayVersion { get; }

        /// <summary>
        /// バージョン番号を取得します。
        /// 表示バージョンが Version フォーマットに準拠している場合は、その Version を返します。
        /// 準拠していない場合は、null を返します。
        /// </summary>
        public Version Version => version;

        public override int GetHashCode() => Id.GetHashCode();

        public override bool Equals(object obj) => obj is ProgramInstallInfo other && other.Id == Id;

        public override string ToString() => $"{Id}, {DisplayName}, {DisplayVersion}";
    }
}
