﻿using System.IO;
using System.Reflection;

namespace SdkEnvironmentCheckerLibrary
{
    public static class NintendoSdkHelper
    {
        private const string NintendoSdkRootMark = "NintendoSdkRootMark";
        private const string SigloRootMark = "SigloRootMark";

        public static DirectoryPath GetSdkRoot()
        {
            var entryLocation = Assembly.GetExecutingAssembly().Location;
            if (!FilePath.TryCreate(entryLocation, out var entryPath)) return DirectoryPath.Empty;

            for (var current = entryPath.Directory; current != null; current = current.ParentDirectory)
            {
                if (File.Exists(Path.Combine(current.FullPath, NintendoSdkRootMark))) return current;
                if (File.Exists(Path.Combine(current.FullPath, SigloRootMark))) return current;
            }

            return DirectoryPath.Empty;
        }
    }
}
