﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Text;
using Nintendo.Foundation.IO;

namespace QCIT_Maker
{
    internal class CommandLineParams
    {
        [CommandLineOption("id",
            Description = "Application ID",
            IsRequired = true)]
        public string InputApplicationId { get; set; }

        [CommandLineOption("release-version",
            DefaultValue = null,
            Description = "ReleaseVersion Value")]
        public string InputReleaseVersion { get; set; }

        [CommandLineOption("content-directory",
            DefaultValue = null,
            Description = "ContentDirectoryPath",
            IsRequired = true)]
        public string ContentDirectoryPath { get; set; }

        [CommandLineOption("sync-list",
            DefaultValue = null,
            Description = "SyncList FilePath")]
        public string SyncListPath { get; set; }

        [CommandLineOption('o', "output-file-path",
            DefaultValue = null,
            Description = "OutputNspFilePath")]
        public string OutputFilePath { get; set; }

        [CommandLineOption('r', "rating-region",
            DefaultValue = null,
            Description = "Rating Region")]
        public string[] RatingRegion { get; set; }

        [CommandLineOption("original-nsp-path",
            DefaultValue = null,
            Description = "OriginalNspFilePath")]
        public string OriginalNspPath { get; set; }

        [CommandLineOption("previous-patch-path",
            DefaultValue = null,
            Description = "PreviousPatchFilePath")]
        public string PreviousPatchPath { get; set; }

        //(SIGLO-76759)QCIT に NAND 空き容量指定オプションを追加する
        [CommandLineOption("free-nand-size",
            Description = "Check Free Nand Size")]
        public string FreeNandSize { get; set; }

        [CommandLineOption("verbose",
            Description = "Verbose Mode")]
        public bool VerboseFlag { get; set; }

        [CommandLineOption("no-cleanup",
            Description = "Not Cleanup WorkDirecotry",
            IsHidden = true)]
        public bool NoCleanupFlag { get; set; }

        [CommandLineOption("debug-mode",
            Description = "Debug Mode",
            IsHidden = true)]
        public bool DebugModeFlag { get; set; }
    }

    internal class Arguments
    {
        private CommandLineParams parameters;

        /// <summary>
        /// 解析した結果のパラメータを渡します。
        /// </summary>
        public CommandLineParams Params
        {
            get { return parameters; }
        }

        /// <summary>
        /// コマンドラインオプションを解析します
        /// </summary>
        /// <returns>解析の成否</returns>
        public bool ParseArgs(string[] args)
        {
            var settings = new CommandLineParserSettings()
            {
                ApplicationDescription = " Make QCIT (.nsp) File ",
                HelpWriter = text =>
                {
                    Console.WriteLine(text);
                },
            };

            if (!new CommandLineParser(settings).ParseArgs(args, out parameters))
            {
                return false;
            }

            return true;
        }

        /// <summary>
        /// 引数解析が失敗したときに呼ばれるメソッドです。
        /// </summary>
        /// <param name="errorInfo">エラーの情報</param>
        private void CommandLineParseError(CommandLineErrorInfo errorInfo)
        {
            Console.Error.WriteLine("CommandLine: {0}", errorInfo.ErrorMessage);
        }
    }
}
