﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "VibrationAmFmCodec.h"

namespace Nintendo { namespace VibrationAmFmCodec {

AmFmDecoder::AmFmDecoder()
{
    m_pContext = new nn::xcd::VibrationAmFmDecoderContext();
}
AmFmDecoder::AmFmDecoder(AmFmCommandTable table, float baseFrequency)
{
    m_pContext = new nn::xcd::VibrationAmFmDecoderContext();
    Reset(table, baseFrequency);

}
AmFmDecoder::~AmFmDecoder()
{
    this->!AmFmDecoder();
}
AmFmDecoder::!AmFmDecoder()
{
    delete m_pContext;
}
void AmFmDecoder::TryDecode(
    [System::Runtime::InteropServices::OutAttribute] float % amplitude,
    [System::Runtime::InteropServices::OutAttribute] float % frequency,
    int amfmCode)
{
    nn::xcd::VibrationAmFmDecoderContext dummyContext = *m_pContext;
    nn::xcd::DecodeVibrationAmFmCode(amfmCode, &dummyContext);
    amplitude = nn::xcd::GetVibrationAmplitudeFromAmFmDecoder(&dummyContext);
    frequency = nn::xcd::GetVibrationFrequencyFromAmFmDecoder(&dummyContext);
}
void AmFmDecoder::Decode(int amfmCode)
{
    nn::xcd::DecodeVibrationAmFmCode(amfmCode, m_pContext);
}
void AmFmDecoder::Reset(AmFmCommandTable table, float baseFrequency)
{
    nn::xcd::VibrationAmFmFormat format = nn::xcd::VibrationAmFmFormat_5BitVer2;
    switch(table)
    {
    case AmFmCommandTable::FiveBitVer1:
        format = nn::xcd::VibrationAmFmFormat_5BitVer1;
        break;
    case AmFmCommandTable::FiveBitVer2:
        format = nn::xcd::VibrationAmFmFormat_5BitVer2;
        break;
    default:
        return;
    }

    nn::xcd::ResetVibrationAmFmDecoderContext(
        m_pContext,
        format,
        baseFrequency);
    m_BaseFrequency = baseFrequency;
}
float AmFmDecoder::GetAmplitude()
{
    return nn::xcd::GetVibrationAmplitudeFromAmFmDecoder(m_pContext);
}
float AmFmDecoder::GetFrequency()
{
    return nn::xcd::GetVibrationFrequencyFromAmFmDecoder(m_pContext);
}



AmFmEncoder::AmFmEncoder()
{
    m_pContext = new nn::xcd::VibrationAmFmEncoderContext();
}
AmFmEncoder::AmFmEncoder(float baseFrequency)
{
    m_pContext = new nn::xcd::VibrationAmFmEncoderContext();
    Reset(baseFrequency);
}
AmFmEncoder::~AmFmEncoder()
{
    this->!AmFmEncoder();
}
AmFmEncoder::!AmFmEncoder()
{
    delete m_pContext;
}

void AmFmEncoder::Reset(float baseFrequency)
{
    nn::xcd::ResetVibrationAmFmEncoderContext(m_pContext, baseFrequency);
    m_BaseFrequency = baseFrequency;
}
int AmFmEncoder::GetAmFmCode(float amplitude, float frequency)
{
    return nn::xcd::EncodeVibrationToAmFmCode(amplitude, frequency, m_pContext);
}

}} // namespace Nintendo::VibrationAmFmCodec
