﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO.Ports;

namespace SetupHciMode
{
    class Program
    {
        private static void ConsoleWriteBytesData(byte[] data)
        {
            int index = 0;
            int size = data.Length;
            while (size > 0)
            {
                if (index != 0)
                {
                    Console.Write(" ");
                }
                Console.Write("{0:X2}", data[index]);
                index++;
                size--;
            }
        }

        static void Main(string[] args)
        {
            if (args.Length < 1)
            {
                Console.WriteLine("Usage: SetupHciMode <com_port>");
                Environment.Exit(1);
            }

            System.Random r = new System.Random(1000);

            string comPort = args[0];

            // HCI-UART 通信
            byte[] commandReset =
            {
                0x01,
                0x03, 0x0C,
                0x00
            };
            byte[] expectedResultReset =
            {
                0x04,
                0x0E, 0x04,
                0x01, 0x03, 0x0C, 0x00
            };

            // UART 通信確立
            SerialPort serialPort = new SerialPort();

            // SerialPort.Open
            serialPort.PortName = comPort;
            serialPort.BaudRate = 115200;
            serialPort.DataBits = 8;
            serialPort.Parity = Parity.None;
            serialPort.StopBits = StopBits.One;
            serialPort.Handshake = Handshake.RequestToSend;
            serialPort.Encoding = Encoding.UTF8;

            serialPort.Open();

            // バッファクリア
            serialPort.DiscardInBuffer();
            serialPort.DiscardOutBuffer();

            byte[] result;
            int bytesInBuffer;
            int retry;

            //Console.WriteLine("cts: {0:X2}", serialPort.CtsHolding);
            if (!serialPort.CtsHolding)
            {
                Console.WriteLine("Press any button to continue.");
                retry = 5;
                while (!serialPort.CtsHolding && retry != 0)
                {
                    System.Threading.Thread.Sleep(1000);
                    retry--;
                    //Console.WriteLine("cts: {0:X2}", serialPort.CtsHolding);
                }
                if (!serialPort.CtsHolding)
                {
                    // データ送信可能にならなかった
                    Console.WriteLine("Failed to detect connection.");
                    serialPort.Close();
                    Environment.Exit(1);
                }
            }

            // データ送信可能
            retry = 10;
            while (retry != 0)
            {
                // Reset 発行
                serialPort.Write(commandReset, 0, commandReset.Length);

                System.Threading.Thread.Sleep(500);

                if (serialPort.BytesToRead == expectedResultReset.Length)
                {
                    bytesInBuffer = serialPort.BytesToRead;

                    result = new byte[bytesInBuffer];
                    serialPort.Read(result, 0, bytesInBuffer);
                    //Console.WriteLine("length: {0:X2}", bytesInBuffer);
                    //ConsoleWriteBytesData(result);
                    //Console.WriteLine("");
                    int i;
                    for (i = 0; i < result.Length - 1; i++)  // 最後のバイトは不問にする
                    {
                        if (!result[i].Equals(expectedResultReset[i]))
                        {
                            break;
                        }
                    }
                    if (i == result.Length - 1)
                    {
                        break;
                    }
                }
                else
                {
                    //Console.WriteLine("length: {0:X2}", serialPort.BytesToRead);

                    serialPort.DiscardInBuffer();
                    serialPort.DiscardOutBuffer();

                    retry--;
                }
            }
            if (retry == 0)
            {
                Console.WriteLine("Failed to reset.");

                serialPort.Close();
                Environment.Exit(1);
            }

            Console.WriteLine("Completed successfully.");
            serialPort.Close();

            // 終了
            Environment.Exit(0);
        }
    }
}
