﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO.Ports;
using System.Diagnostics;

using System.Globalization;

namespace NXControllerFirmwareUpdater
{
    public partial class Form1 : Form
    {
        private int step;

        private string comPort = null;
        private string hexPath = null;

        private Process processSetupHciMode = null;
        private bool processSetupHciModeRunning = false;
        private Process processReadProductInfo = null;
        private bool processReadProductInfoRunning = false;
        private Process processChipLoad = null;
        private bool processChipLoadRunning = false;

        public event EventHandler ExitedEvent = null;
        public event DataReceivedEventHandler OutputEvent = null;
        public event DataReceivedEventHandler ErrorEvent = null;

        private string apppath = null;

        private string hexNxCntl1 = null;
        private string hexNxCntl2 = null;
        private string hexNxCntl3 = null;
        private string hexNxCntl4 = null;
        private string hexNxCntl5 = null;
        private string hexNxCntl6 = null;
        private string hexNxCntl7 = null;
        private string hexNxCntl8 = null;
        private string hexNxCntlVer = null;
        private string productInfoNxCntlType = null;
        private string productInfoNxCntlRev = null;

        private bool selectHexFile = true;

        public Form1()
        {
            InitializeComponent();

            apppath = System.IO.Path.GetDirectoryName(Application.ExecutablePath);

            this.Text = "NX Controller Firmware Updater";
            // ファームウェアバージョンの取得
            string[] files1, files2, files3, files4, files5, files6, files7, files8;
            files1 = System.IO.Directory.GetFiles(
                @"data", "NX_Controller_Left_FW_*.hex", System.IO.SearchOption.AllDirectories);
            files2 = System.IO.Directory.GetFiles(
                @"data", "NX_Controller_Right_FW_*.hex", System.IO.SearchOption.AllDirectories);
            files3 = System.IO.Directory.GetFiles(
                @"data", "NX_Controller_EP1_FW_*.hex", System.IO.SearchOption.AllDirectories);
            files4 = System.IO.Directory.GetFiles(
                @"data", "NX_Controller_EP2_FW_*.hex", System.IO.SearchOption.AllDirectories);

            files5 = System.IO.Directory.GetFiles(
                @"data", "NX_Controller_EP1_Left_FW_*.hex", System.IO.SearchOption.AllDirectories);
            files6 = System.IO.Directory.GetFiles(
                @"data", "NX_Controller_EP1_Right_FW_*.hex", System.IO.SearchOption.AllDirectories);
            files7 = System.IO.Directory.GetFiles(
                @"data", "NX_Controller_EP2_Left_FW_*.hex", System.IO.SearchOption.AllDirectories);
            files8 = System.IO.Directory.GetFiles(
                @"data", "NX_Controller_EP2_Right_FW_*.hex", System.IO.SearchOption.AllDirectories);
            if (files1.Length != 0 && files2.Length != 0)
            {
                // 最新バージョンを先頭に持ってくる
                Array.Sort(files1);
                Array.Reverse(files1);
                Array.Sort(files2);
                Array.Reverse(files2);

                hexNxCntl1 = files1[0];
                System.Globalization.StringInfo si1 = new System.Globalization.StringInfo(hexNxCntl1);
                string major1 = si1.SubstringByTextElements(28, 1);
                string minor1 = si1.SubstringByTextElements(29, 2);
                hexNxCntl2 = files2[0];
                System.Globalization.StringInfo si2 = new System.Globalization.StringInfo(hexNxCntl2);
                string major2 = si2.SubstringByTextElements(29, 1);
                string minor2 = si2.SubstringByTextElements(30, 2);

                if (major1 == major2 && minor1 == minor2)
                {
                    hexNxCntlVer = "v" + major1 + "." + minor1;
                    this.Text = "NX Controller Firmware Updater v" + major1 + "." + minor1;
                    selectHexFile = false;
                }
            }
            else if (files3.Length != 0 && files4.Length != 0)
            {
                // 最新バージョンを先頭に持ってくる
                Array.Sort(files3);
                Array.Reverse(files3);
                Array.Sort(files4);
                Array.Reverse(files4);

                hexNxCntl3 = files3[0];
                System.Globalization.StringInfo si3 = new System.Globalization.StringInfo(hexNxCntl3);
                string major3 = si3.SubstringByTextElements(27, 1);
                string minor3 = si3.SubstringByTextElements(28, 2);
                hexNxCntl4 = files4[0];
                System.Globalization.StringInfo si4 = new System.Globalization.StringInfo(hexNxCntl4);
                string major4 = si4.SubstringByTextElements(27, 1);
                string minor4 = si4.SubstringByTextElements(28, 2);

                if (major3 == major4 && minor3 == minor4)
                {
                    hexNxCntlVer = "v" + major3 + "." + minor3;
                    this.Text = "NX Controller Firmware Updater v" + major3 + "." + minor3;
                    selectHexFile = false;
                }
            }
            else if (files5.Length != 0 && files6.Length != 0 && files7.Length != 0 && files8.Length != 0)
            {
                // 最新バージョンを先頭に持ってくる
                Array.Sort(files5);
                Array.Reverse(files5);
                Array.Sort(files6);
                Array.Reverse(files6);
                Array.Sort(files7);
                Array.Reverse(files7);
                Array.Sort(files8);
                Array.Reverse(files8);

                hexNxCntl5 = files5[0];
                System.Globalization.StringInfo si5 = new System.Globalization.StringInfo(hexNxCntl5);
                string major5 = si5.SubstringByTextElements(32, 1);
                string minor5 = si5.SubstringByTextElements(33, 2);
                hexNxCntl6 = files6[0];
                System.Globalization.StringInfo si6 = new System.Globalization.StringInfo(hexNxCntl6);
                string major6 = si6.SubstringByTextElements(33, 1);
                string minor6 = si6.SubstringByTextElements(34, 2);
                hexNxCntl7 = files7[0];
                System.Globalization.StringInfo si7 = new System.Globalization.StringInfo(hexNxCntl7);
                string major7 = si7.SubstringByTextElements(32, 1);
                string minor7 = si7.SubstringByTextElements(33, 2);
                hexNxCntl8 = files8[0];
                System.Globalization.StringInfo si8 = new System.Globalization.StringInfo(hexNxCntl8);
                string major8 = si8.SubstringByTextElements(33, 1);
                string minor8 = si8.SubstringByTextElements(34, 2);

                if (major5 == major6 && minor5 == minor6)
                {
                    hexNxCntlVer = "v" + major5 + "." + minor5;
                    this.Text = "NX Controller Firmware Updater v" + major5 + "." + minor5;
                    selectHexFile = false;
                }
            }

            panel1.Parent = panelParent;
            panel2.Parent = panelParent;
            panel3.Parent = panelParent;
            panel4.Parent = panelParent;
            panel5.Parent = panelParent;
            panel6.Parent = panelParent;
            panel7.Parent = panelParent;

            tabControl1.Visible = false;

            buttonNext.Enabled = false;

            ExitedEvent = new EventHandler(event_Exited);
            OutputEvent = new DataReceivedEventHandler(event_OutputDataReceived);
            ErrorEvent = new DataReceivedEventHandler(event_ErrorDataReceived);

            step = 1;
        }

        private void nextButton_Click(object sender, EventArgs e)
        {
            switch(step)
            {
                case 1:
                    {
                        comPort = comboBox1.Text;

                        panel1.Visible = false;

                        panel5.Visible = true;

                        step++;

                        return;
                    }
                case 2:
                    {
                        panel5.Visible = false;

                        panel6.Visible = true;
                        label14.Visible = true;
                        buttonNext.Enabled = false;

                        step++;

                        // 事前に HCI UART 接続を確立されるために SetupHciMode を実行する
                        processSetupHciMode = new Process();

                        processSetupHciMode.StartInfo.FileName = apppath + @"\bin\SetupHciMode.exe";
                        processSetupHciMode.StartInfo.Arguments = comPort;
                        processSetupHciMode.StartInfo.WorkingDirectory = apppath + @"";

                        processSetupHciMode.StartInfo.UseShellExecute = false;
                        processSetupHciMode.StartInfo.CreateNoWindow = true;
                        processSetupHciMode.StartInfo.RedirectStandardOutput = true;
                        processSetupHciMode.StartInfo.RedirectStandardError = true;

                        processSetupHciMode.EnableRaisingEvents = true;

                        processSetupHciMode.OutputDataReceived += new DataReceivedEventHandler(process_OutputDataReceived);
                        processSetupHciMode.ErrorDataReceived += new DataReceivedEventHandler(process_ErrorDataReceived);
                        processSetupHciMode.Exited += new EventHandler(process_Exited);

                        processSetupHciModeRunning = true;

                        processSetupHciMode.Start();
                        processSetupHciMode.BeginOutputReadLine();
                        processSetupHciMode.BeginErrorReadLine();

                        return;
                    }
                case 3:
                    {
                        panel6.Visible = false;

                        step++;

                        if (selectHexFile)
                        {
                            panel2.Visible = true;
                            buttonNext.Text = "Update";
                            buttonNext.Enabled = false;

                            string[] files;
                            files = System.IO.Directory.GetFiles(
                                @"data", "NX_Controller_*_FW_*.hex", System.IO.SearchOption.AllDirectories);
                            comboBox2.Items.AddRange(files);
                            files = System.IO.Directory.GetFiles(
                                @"data", "A_20734A1-*.hex", System.IO.SearchOption.AllDirectories);
                            comboBox2.Items.AddRange(files);

                            return;
                        }
                        else
                        {
                            panel7.Visible = true;
                            label2.Text = "NX Controller " + productInfoNxCntlType + " FW " + hexNxCntlVer;
                            buttonNext.Text = "Update";
                            buttonNext.Enabled = false;

                            if (hexNxCntl1 != null && hexNxCntl2 != null)
                            {
                                if (productInfoNxCntlType == "Left")
                                {
                                    comboBox2.Text = hexNxCntl1;
                                }
                                else
                                {
                                    comboBox2.Text = hexNxCntl2;
                                }
                            }
                            else if (hexNxCntl3 != null && hexNxCntl4 != null)
                            {
                                if (productInfoNxCntlRev.IndexOf("EP1") != -1)
                                {
                                    comboBox2.Text = hexNxCntl3;
                                }
                                else
                                {
                                    comboBox2.Text = hexNxCntl4;
                                }
                            }
                            else if (hexNxCntl5 != null && hexNxCntl6 != null && hexNxCntl7 != null && hexNxCntl8 != null)
                            {
                                if (productInfoNxCntlRev.IndexOf("EP1") != -1)
                                {
                                    if (productInfoNxCntlType == "Left")
                                    {
                                        comboBox2.Text = hexNxCntl5;
                                    }
                                    else
                                    {
                                        comboBox2.Text = hexNxCntl6;
                                    }
                                }
                                else
                                {
                                    if (productInfoNxCntlType == "Left")
                                    {
                                        comboBox2.Text = hexNxCntl7;
                                    }
                                    else
                                    {
                                        comboBox2.Text = hexNxCntl8;
                                    }
                                }
                            }

                            buttonNext.Enabled = true;

                            return;
                        }
                    }
                case 4:
                    {
                        hexPath = comboBox2.Text;

                        buttonNext.Text = "Next";
                        label5.Text = "Setup.";

                        buttonNext.Enabled = false;
                        buttonCancel.Enabled = false;

                        panel2.Visible = false;
                        panel3.Visible = true;

                        step++;

                        // ChipLoad.exe の実行
                        processChipLoad = new Process();
                        string apppath = System.IO.Path.GetDirectoryName(Application.ExecutablePath);

                        processChipLoad.StartInfo.FileName = apppath + @"\bin\ChipLoad.exe";
                        processChipLoad.StartInfo.Arguments = @"-BLUETOOLMODE -MINIDRIVER data\uart.hex -FIRMWARE " + hexPath + @" -BTP data\NX_Controller_FW.btp -PORT " + comPort + @" -NOERASE";
                        processChipLoad.StartInfo.WorkingDirectory = apppath + @"";

                        processChipLoad.StartInfo.UseShellExecute        = false;
                        processChipLoad.StartInfo.CreateNoWindow         = true;
                        processChipLoad.StartInfo.RedirectStandardOutput = true;
                        processChipLoad.StartInfo.RedirectStandardError  = true;

                        processChipLoad.EnableRaisingEvents = true;

                        processChipLoad.OutputDataReceived += new DataReceivedEventHandler(process_OutputDataReceived);
                        processChipLoad.ErrorDataReceived  += new DataReceivedEventHandler(process_ErrorDataReceived);
                        processChipLoad.Exited += new EventHandler(process_Exited);

                        processChipLoadRunning = true;

                        processChipLoad.Start();
                        processChipLoad.BeginOutputReadLine();
                        processChipLoad.BeginErrorReadLine();

                        Console.WriteLine("out:");

                        return;
                    }
                case 5:
                    {
                        buttonNext.Text = "Finish";

                        panel3.Visible = false;
                        panel4.Visible = true;

                        step++;

                        return;
                    }
                case 6:
                    {
                        this.Close();

                        return;
                    }
            }
        }

        private void cancelButton_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void comboBox1_DropDown(object sender, EventArgs e)
        {
            // COM ポートリストの更新
            string[] ports = SerialPort.GetPortNames();
            comboBox1.Items.Clear();
            foreach (string port in ports)
            {
                comboBox1.Items.Add(port);
            }
        }

        void event_OutputDataReceived(object sender, DataReceivedEventArgs e)
        {
            if (e.Data != null)
            {
                //Console.WriteLine("out:" + e.Data);
                if (processSetupHciModeRunning)
                {
                    if (e.Data.IndexOf("Completed successfully.") > -1)
                    {
                        label14.Visible = false;
                        label15.Visible = true;
                    }
                }
                else if (processReadProductInfoRunning)
                {
                    if (e.Data.IndexOf("The current device PRODUCTINFO is") > -1)
                    {
                        System.Globalization.StringInfo si = new System.Globalization.StringInfo(e.Data);
                        string type = si.SubstringByTextElements(38, 2);
                        if (type == "01")
                        {
                            productInfoNxCntlType = "Left";
                        }
                        else if (type == "02")
                        {
                            productInfoNxCntlType = "Right";
                        }
                        else
                        {
                            productInfoNxCntlType = " ";
                            selectHexFile = true;
                        }
                        string revStr = si.SubstringByTextElements(40, 2);
                        byte rev = byte.Parse(revStr, System.Globalization.NumberStyles.AllowHexSpecifier);
                        string[] product = { "EP", "DP", "MP" };
                        if ((rev & 0x30) != 0x30)
                        {
                            productInfoNxCntlRev = product[(rev & 0x30) >> 4];
                            productInfoNxCntlRev += (((rev & 0x0C) >> 2) + 1).ToString("D");
                            if ((rev & 0x03) != 0x00 || (rev & 0x30) == 0x00)
                            {
                                productInfoNxCntlRev += "-" + ((rev & 0x03) + 1).ToString("D");
                            }
                            if ((rev & 0x40) == 0x40)
                            {
                                productInfoNxCntlRev += "-A";
                            }
                        }
                        else
                        {
                            productInfoNxCntlRev = "Rev" + int.Parse(revStr, System.Globalization.NumberStyles.HexNumber).ToString("D");
                            selectHexFile = true;
                        }

                        label15.Visible = false;

                        label19.Visible = true;
                        label16.Text = "NX Controller " + productInfoNxCntlType + " (" + productInfoNxCntlRev + ")";
                        label16.Visible = true;

                        label13.Visible = true;
                    }
                }
                else if (processChipLoadRunning)
                {
                    if (e.Data.IndexOf("Download minidriver") > -1)
                    {
                        label5.Text = "Setup.";
                    }
                    if (e.Data.IndexOf("Download firmware") > -1)
                    {
                        label5.Text = "Updating controller firmware.";
                    }
                    if (e.Data.IndexOf("Completed successfully") > -1)
                    {
                        label5.Text = "Update finished successfully. Click Next to proceed.";
                        buttonNext.Enabled = true;
                        buttonNext.Visible = true;
                        buttonExit.Visible = false;
                    }
                    if (e.Data.IndexOf("Terminated with error") > -1)
                    {
                        label5.Text = "Update failed.";
                    }
                    textBox1.AppendText(e.Data + "\r\n");
                }
            }
        }
        void event_ErrorDataReceived(object sender, DataReceivedEventArgs e)
        {
            if (e.Data != null)
            {
                //Console.WriteLine("err:" + e.Data);
                if (processChipLoadRunning)
                {

                    if (e.Data.IndexOf("Download minidriver") > -1)
                    {
                        label5.Text = "Setup.";
                    }
                    if (e.Data.IndexOf("Download firmware") > -1)
                    {
                        label5.Text = "Updating controller firmware.";
                    }
                    if (e.Data.IndexOf("Completed successfully") > -1)
                    {
                        label5.Text = "Update finished successfully. Click Next to proceed.";
                        buttonNext.Enabled = true;
                        buttonNext.Visible = true;
                        buttonExit.Visible = false;
                    }
                    if (e.Data.IndexOf("Terminated with error") > -1)
                    {
                        label5.Text = "Update failed.";
                    }
                    textBox1.AppendText(e.Data + "\r\n");
                }
            }
        }
        void event_Exited(object sender, EventArgs e)
        {
            //Console.WriteLine("ext:");
            if (processSetupHciModeRunning)
            {
                processSetupHciModeRunning = false;

                if (!label15.Visible)
                {
                    label14.Text = "Failed to detect controller.";
                    buttonNext.Visible = false;
                    buttonExit.Visible = true;
                    return;
                }

                // ReadProductInfo を実行する
                processReadProductInfo = new Process();

                processReadProductInfo.StartInfo.FileName = apppath + @"\bin\ReadProductInfo.exe";
                processReadProductInfo.StartInfo.Arguments = comPort;
                processReadProductInfo.StartInfo.WorkingDirectory = apppath + @"";

                processReadProductInfo.StartInfo.UseShellExecute = false;
                processReadProductInfo.StartInfo.CreateNoWindow = true;
                processReadProductInfo.StartInfo.RedirectStandardOutput = true;
                processReadProductInfo.StartInfo.RedirectStandardError = true;

                processReadProductInfo.EnableRaisingEvents = true;

                processReadProductInfo.OutputDataReceived += new DataReceivedEventHandler(process_OutputDataReceived);
                processReadProductInfo.ErrorDataReceived += new DataReceivedEventHandler(process_ErrorDataReceived);
                processReadProductInfo.Exited += new EventHandler(process_Exited);

                processReadProductInfoRunning = true;

                processReadProductInfo.Start();
                processReadProductInfo.BeginOutputReadLine();
                processReadProductInfo.BeginErrorReadLine();
            }
            else if (processReadProductInfoRunning)
            {
                processReadProductInfoRunning = false;

                if (label16.Visible == true)
                {
                    // Update 実行を許可
                    buttonNext.Enabled = true;
                }
                else
                {
                    label15.Text = "Failed to read controller product info.";
                }
            }
            else if (processChipLoadRunning)
            {
                // TORIAEZU: OutputDataReceived の前に Exited が来てしまうのでこちらではハンドルしない
                //processChipLoadRunning = false;
#if true
                if (label5.Text == "Update finished successfully. Click Next to proceed.")
                {
                    buttonNext.Enabled = true;
                    buttonNext.Visible = true;
                    buttonExit.Visible = false;
                }
                else
                {
                    label5.Text = "Update failed.";
                    buttonNext.Visible = false;
                    buttonExit.Visible = true;
                }
#endif
            }
        }

        void process_OutputDataReceived(object sender, DataReceivedEventArgs e)
        {
            this.Invoke(OutputEvent, new object[2] { sender, e });
        }
        void process_ErrorDataReceived(object sender, DataReceivedEventArgs e)
        {
            this.Invoke(ErrorEvent, new object[2] { sender, e });
        }
        void process_Exited(object sender, EventArgs e)
        {
            this.Invoke(ExitedEvent, new object[2] { sender, e });
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (processChipLoad != null && !processChipLoad.HasExited)
            {
                // ファームウェア更新中は閉じない
                e.Cancel = true;
            }
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            try
            {
                if (processSetupHciMode != null)
                {
                    processSetupHciMode.Kill();
                    processSetupHciMode.Close();
                    processSetupHciMode.Dispose();
                }
                if (processReadProductInfo != null)
                {
                    processReadProductInfo.Kill();
                    processReadProductInfo.Close();
                    processReadProductInfo.Dispose();
                }
                if (processChipLoad != null)
                {
                    processChipLoad.Kill();
                    processChipLoad.Close();
                    processChipLoad.Dispose();
                }
            }
            catch
            {
            }
        }

        private void comboBox1_TextUpdate(object sender, EventArgs e)
        {
            if (comboBox1.Text != "")
            {
                buttonNext.Enabled = true;
            }
            else
            {
                buttonNext.Enabled = false;
            }
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBox1.Text != "")
            {
                buttonNext.Enabled = true;
            }
            else
            {
                buttonNext.Enabled = false;
            }
        }

        private void comboBox2_TextUpdate(object sender, EventArgs e)
        {
            if (comboBox2.Text != "")
            {
                buttonNext.Enabled = true;
            }
            else
            {
                buttonNext.Enabled = false;
            }
        }

        private void comboBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBox2.Text != "")
            {
                buttonNext.Enabled = true;
            }
            else
            {
                buttonNext.Enabled = false;
            }
        }

        private void buttonExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
