﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// セッションの情報です。
    /// </summary>
    internal struct SessionInfo
    {
        /// <summary>
        /// 開発機の名前を取得または設定します。
        /// </summary>
        internal string Name { get; set; }

        /// <summary>
        /// 開発機の IP アドレスを取得または設定します。
        /// </summary>
        internal string IpAddress { get; set; }

        /// <summary>
        /// 開発機のポート番号を取得または設定します。
        /// </summary>
        internal int Port { get; set; }

        /// <summary>
        /// ユーザ設定を取得または設定します。
        /// </summary>
        internal UserConfig UserConfig { get; set; }

        /// <summary>
        /// 入出力ポートマネージャを取得または設定します。
        /// </summary>
        internal IoPortManager IoPortManager { get; set; }

        /// <summary>
        /// ゲームパッドマネージャを取得または設定します。
        /// </summary>
        internal GamePadManager GamePadManager { get; set; }

        /// <summary>
        /// セッションの対向となる開発機の名前を返すメソッドを取得または設定します。
        /// </summary>
        internal Func<IList<string>> GetSessionNames { get; set; }
    }
}
